using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using Microsoft.Surface;
using Microsoft.Surface.Presentation;
using Microsoft.Surface.Presentation.Controls;

namespace FingersDance.Control.TimeLine
{
    /// <summary>
    /// Interaction logic for SurfaceWindow1.xaml
    /// </summary>
    public partial class SurfaceTimeLineTest : SurfaceWindow
    {

        DispatcherTimer timer;  // handles position of slider and player
        bool isDragging = false;
        bool isPlaying = false;



        /// <summary>
        /// Default constructor.
        /// </summary>
        public SurfaceTimeLineTest()
        {
            InitializeComponent();

            // Add handlers for Application activation events
            initplayer();
            AddActivationHandlers();
        }

        #region Handlers
        /// <summary>
        /// Occurs when the window is about to close. 
        /// </summary>
        /// <param name="e"></param>
        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);

            // Remove handlers for Application activation events
            RemoveActivationHandlers();
        }

        /// <summary>
        /// Adds handlers for Application activation events.
        /// </summary>
        private void AddActivationHandlers()
        {
            // Subscribe to surface application activation events
            ApplicationLauncher.ApplicationActivated += OnApplicationActivated;
            ApplicationLauncher.ApplicationPreviewed += OnApplicationPreviewed;
            ApplicationLauncher.ApplicationDeactivated += OnApplicationDeactivated;
        }

        /// <summary>
        /// Removes handlers for Application activation events.
        /// </summary>
        private void RemoveActivationHandlers()
        {
            // Unsubscribe from surface application activation events
            ApplicationLauncher.ApplicationActivated -= OnApplicationActivated;
            ApplicationLauncher.ApplicationPreviewed -= OnApplicationPreviewed;
            ApplicationLauncher.ApplicationDeactivated -= OnApplicationDeactivated;
        }

        /// <summary>
        /// This is called when application has been activated.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationActivated(object sender, EventArgs e)
        {
            //TODO: enable audio, animations here
        }

        /// <summary>
        /// This is called when application is in preview mode.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationPreviewed(object sender, EventArgs e)
        {
            //TODO: Disable audio here if it is enabled

            //TODO: optionally enable animations here
        }

        /// <summary>
        ///  This is called when application has been deactivated.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationDeactivated(object sender, EventArgs e)
        {
            //TODO: disable audio, animations here
        }
        #endregion

        #region SurfaceWindows events

        private void SurfaceWindow_Activated(object sender, EventArgs e)
        {
            timer = new DispatcherTimer();
            //timer.Interval = TimeSpan.FromSeconds(1);
            timer.Interval = TimeSpan.FromMilliseconds(250);
            timer.Tick += new EventHandler(timer_Tick);
        }
        #endregion

        #region Timer
        void timer_Tick(object sender, EventArgs e)
        {
            //Slider Position
            labelPosition.Content = sliderBase.Value;
            //Media Position ToString and TotalMilliseconds
            labelMediaPositionToString.Content=mediaelement.Position.ToString();
            labelMediaPositionContent.Content = mediaelement.Position.TotalMilliseconds;
            //Si le slider n'est pas en train d'etre boug, on change sa valeur
            if (!isDragging)
            {
                sliderBase.Value = mediaelement.Position.TotalMilliseconds;
            }

        }
        #endregion

        #region MediaElement events
        private void MediaElement_MediaEnded(object sender, RoutedEventArgs e)
        {
            mediaelement.Stop();
        }

        private void mediaelement_MediaOpened(object sender, RoutedEventArgs e)
        {
            labelDuration.Content = mediaelement.NaturalDuration.ToString();

            sliderBase.Maximum = mediaelement.NaturalDuration.TimeSpan.TotalMilliseconds;
            labelSliderMax.Content = sliderBase.Maximum;
            //initialisation du timer
            timer.Start();
        }
        #endregion

        #region Slider

        private void sliderBase_ValueChanged(object sender, RoutedPropertyChangedEventArgs<double> e)
        {
            //TODO
            if (!isDragging)
            {

                int SliderValue = (int)sliderBase.Value;

                // Overloaded constructor takes the arguments days, hours, minutes, seconds, miniseconds.
                // Create a TimeSpan with miliseconds equal to the slider value.
                TimeSpan ts = new TimeSpan(0, 0, 0, 0, SliderValue);
                mediaelement.Position = ts;
                mediaelement.Play();
            }
            
        }

        private void sliderBase_DragEnter(object sender, DragEventArgs e)
        {
            isDragging = true;
            mediaelement.Pause();
        }

        private void sliderBase_DragLeave(object sender, DragEventArgs e)
        {
            isDragging = false;
            //mediaelement.Position = TimeSpan.FromSeconds(sliderBase.Value);

        }

        private void sliderBase_ContactEnter(object sender, ContactEventArgs e)
        {
            isDragging = true;
            mediaelement.Pause();
        }

        private void sliderBase_ContactLeave(object sender, ContactEventArgs e)
        {
            isDragging = false;
            mediaelement.Position = TimeSpan.FromSeconds(sliderBase.Value);
        }

        private void sliderBase_ContactChanged(object sender, ContactEventArgs e)
        {
           // isDragging = false;
            //mediaelement.Position = TimeSpan.FromMilliseconds(sliderBase.Value);
        }
        #endregion

        #region Player
        private void initplayer()
        {
            mediaelement.LoadedBehavior = MediaState.Manual;        
        }

        private void butonPlayPause_Click(object sender, RoutedEventArgs e)
        {
            if (!isPlaying)//Play
            {
                isPlaying = true;
                try
                {
                    mediaelement.Play();
                }
                catch (Exception ex) { }
            }
            else//Pause
            {
                isPlaying = false;
                try
                {
                    mediaelement.Pause();
                }
                catch (Exception exx) { }
            }
        }
        private void SurfaceButton_Click(object sender, RoutedEventArgs e)
        {
            mediaelement.Stop();
        }

        private void SurfaceButton_ContactDown(object sender, ContactEventArgs e)
        {
            mediaelement.Stop();
        }

    #endregion





    }
        

}