﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using Microsoft.Surface;
using Microsoft.Surface.Presentation;
using Microsoft.Surface.Presentation.Controls;
using System.Collections.Generic;
using System.Windows.Media.Imaging;

namespace FingersDance.Control.ListVideo
{
    public partial class UserControlListVideo
    {
        //Creation d'un Event pour Chaque Item Video
        public event EventHandler EH_ItemVideo1_ContactDown;
        public event EventHandler EH_ItemVideo2_ContactDown;

        List<string> _Videos = new List<string>();

        public UserControlListVideo()
        {
            this.InitializeComponent();

            // Insert code required on object creation below this point.
        }

        private void ItemVideo1_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (EH_ItemVideo1_ContactDown != null)
                EH_ItemVideo1_ContactDown(this, new EventArgs());
        }

        private void ItemVideo2_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (EH_ItemVideo2_ContactDown != null)
                EH_ItemVideo2_ContactDown(this, new EventArgs());
        }

        //Event appelé lors de la selection d'un Item dans la Video List
        private void ItemVideo1_ContactTapGesture(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (EH_ItemVideo1_ContactDown != null)
                EH_ItemVideo1_ContactDown(this, new EventArgs());
        }

        private void ButtonImporter_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            AddVideoToList();
        }

        private void ButtonImporter_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            AddVideoToList();
        }

        private void AddVideoToList()
        {
            try
            {
                string[] Files = new string[1];
                if (System.IO.Directory.Exists(PathImporter.Text))
                    Files = System.IO.Directory.GetFiles(PathImporter.Text);
                else
                    if (System.IO.File.Exists(PathImporter.Text))
                        Files[0] = PathImporter.Text;
                if (Files != null)
                    foreach (string elt in Files)
                        if (elt.ToLower().EndsWith(".wmv")) // .....
                            try
                            {
                                Image item = getFirstPreview(elt);
                                if (item != null)
                                {
                                    SurfaceListBoxItem Contener = new SurfaceListBoxItem();
                                    Contener.Content = item;
                                    Contener.ContactHoldGesture += new ContactEventHandler(Contener_ContactHoldGesture);
                                    stackPanel.Children.Add(Contener);

                                    _Videos.Add(elt);
                                }
                            }
                            catch (Exception ex) { }
            }
            catch (Exception) { }
        }

        void Contener_ContactHoldGesture(object sender, ContactEventArgs e)
        {
            SurfaceContextMenu Menu = new SurfaceContextMenu();
            Menu.Items.Add("Supprimer");
            ((SurfaceListBoxItem)sender).ContextMenu = Menu;

        }

        Image getFirstPreview(string path)
        {
            MediaPlayer _player = new MediaPlayer();
            _player.Open(new Uri(path));
            _player.Play();
            _player.Position = new TimeSpan(0, 0, 5);
            System.Threading.Thread.Sleep(800);
            RenderTargetBitmap target = new RenderTargetBitmap(100, 100, 1 / 100, 1 / 100, PixelFormats.Pbgra32);
            DrawingVisual visual = new DrawingVisual();
            DrawingContext context = visual.RenderOpen();
            Rect frameRect = new Rect();
            frameRect.Height = target.Height;
            frameRect.Width = target.Width;
            context.DrawVideo(_player, frameRect);
            context.Close();
            target.Render(visual);
            Image _prev = new Image();
            _prev.Source = BitmapFrame.Create(target).GetAsFrozen() as BitmapFrame;
            _player.Stop();

            return _prev;
        }
    }
}