﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using Microsoft.Surface;
using Microsoft.Surface.Presentation;
using System.Xml.Serialization;
using System.Reflection;

namespace FingersDance.Control.Menu
{
	public partial class UserControlMenu
	{
		public UserControlMenu()
		{
			this.InitializeComponent();
            initChildSize();

			// Insert code required on object creation below this point.
		}

        //Premet de deplacer les sous menus vers la droite pour avoir un effect tree view
         private void initChildSize()
        {
            StreamReader reader = null;
            FileInfo assemblyPath = new FileInfo(Assembly.GetExecutingAssembly().Location);
            DirectoryInfo info = assemblyPath.Directory;
            try
            {
                reader = new StreamReader(info.FullName.ToString() + "\\Resources\\menu.xml");
            }
            catch (Exception e)
            {
                // do nothing
            }
            XmlSerializer serializer = new XmlSerializer(typeof(Menu));
            Menu temp = (Menu)serializer.Deserialize(reader);
            foreach (Item elt in temp.Items)
                try
                {
                    LayoutRoot.Children.Add(CreateMenuItem(elt));
                }
                catch (Exception) { }
            reader.Close();
        }

         public StackPanel CreateMenuItem(Item item)
         {
             try
             {
                 StackPanel MItem = new StackPanel();
                 CustomSurfaceButton ItemButton = new CustomSurfaceButton();
                 ItemButton.Content = item.Name;
                 if (item.Items.Count > 0)
                 {
                     ItemButton.ContactDown += ButtonMenu_ContactDown;
                     ItemButton.Click += ButtonMenu_ContactDown;
                     MItem.Children.Add(ItemButton);
                     StackPanel Temp = new StackPanel();
                     Temp.Margin = new Thickness(15,0,0,0);
                     foreach (Item elt in item.Items)
                         try
                         {
                             Temp.Children.Add(CreateMenuItem(elt));
                         }
                         catch (Exception) { }
                     Temp.Name = ItemButton.Content + "Panel";
                     Temp.Visibility = Visibility.Collapsed;
                     MItem.Children.Add(Temp);
                 }
                 else
                 {
                     ItemButton.Action = item.Action;
                     //ItemButton.ContactDown += GenerateAction;
                     //ItemButton.Click += GenerateAction;
                     MItem.Children.Add(ItemButton);
                 }
                 return MItem;
             }
             catch (Exception ex)
             {
                 throw ex;
             }
         }
        
        /*
         *  Déplacé dans le CustomSurfaceButton
         
         private void GenerateAction(Object sender, RoutedEventArgs Event)
         {
             try
             {
                 ActionFactory.ActionGenerator AG = (new ActionFactory.ActionFactory()).GetGenerator();
                 FingersDance.Actions.ActionBase action = AG.GetAction("Action" + ((Microsoft.Surface.Presentation.Controls.SurfaceButton)sender).Content, null);
                 if (action != null)
                 {
                     //action.Execute();
                     //this.debug.addToList(action.GetType().ToString());
                 }
             }
             catch (Exception e) { }
         }
         
         * 
         */

         private void ButtonMenu_ContactDown(object sender, RoutedEventArgs e)
         {
             foreach (UIElement Child in ((Panel)((CustomSurfaceButton)sender).Parent).Children)
                 try
                 {
                     if (((StackPanel)Child).Name.Equals(((Microsoft.Surface.Presentation.Controls.SurfaceButton)sender).Content + "Panel"))
                     {
                         if (((StackPanel)Child).Visibility == Visibility.Collapsed)
                         {
                             ((StackPanel)Child).Visibility = Visibility.Visible;
                         }
                         else
                         {
                             ((StackPanel)Child).Visibility = Visibility.Collapsed;
                         }
                         return;
                     }
                 }
                 catch (Exception ex) { }
         }

        #region Events

     /*    
        //Annotation
        private void ButtonAnnotation_Click(object sender, RoutedEventArgs e)
        {
            if (PanelAnnotation.Visibility == Visibility.Collapsed)
            {
                PanelAnnotation.Visibility = Visibility.Visible;
            }
            else
            {
                PanelAnnotation.Visibility = Visibility.Collapsed;
            }
        }
        //Recherche
        private void ButtonRecherche_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (PanelRecherche.Visibility == Visibility.Collapsed)
            {
                PanelRecherche.Visibility = Visibility.Visible;
            }
            else
            {
                PanelRecherche.Visibility = Visibility.Collapsed;
            }
        }           
        
        private void ButtonRecherche_Click(object sender, RoutedEventArgs e)
        {
            if (PanelRecherche.Visibility == Visibility.Collapsed)
            {
                PanelRecherche.Visibility = Visibility.Visible;
            }
            else
            {
                PanelRecherche.Visibility = Visibility.Collapsed;
            }
        }
        //ChildCine
        private void ButtonChildCine_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (PanelChildCine.Visibility == Visibility.Collapsed)
            {
                PanelChildCine.Visibility = Visibility.Visible;
            }
            else
            {
                PanelChildCine.Visibility = Visibility.Collapsed;
            } 
        }

        private void ButtonChildCine_Click(object sender, RoutedEventArgs e)
        {
            if (PanelChildCine.Visibility == Visibility.Collapsed)
            {
                PanelChildCine.Visibility = Visibility.Visible;
            }
            else
            {
                PanelChildCine.Visibility = Visibility.Collapsed;
            }
        }
        //ChildCore
        private void ButtonChildChore_Click(object sender, RoutedEventArgs e)
        {
            if (PanelChildChore.Visibility == Visibility.Collapsed)
            {
                PanelChildChore.Visibility = Visibility.Visible;
            }
            else
            {
                PanelChildChore.Visibility = Visibility.Collapsed;
            }
        }

        private void ButtonChildChore_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (PanelChildChore.Visibility == Visibility.Collapsed)
            {
                PanelChildChore.Visibility = Visibility.Visible;
            }
            else
            {
                PanelChildChore.Visibility = Visibility.Collapsed;
            }
        }
        //Child1MouvCam
        private void ButtonChild1MouvCam_Click(object sender, RoutedEventArgs e)
        {
            if (PanelChild1MouvCam.Visibility == Visibility.Collapsed)
            {
                PanelChild1MouvCam.Visibility = Visibility.Visible;
            }
            else
            {
                PanelChild1MouvCam.Visibility = Visibility.Collapsed;
            }
        }

        private void ButtonChild1MouvCam_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (PanelChild1MouvCam.Visibility == Visibility.Collapsed)
            {
                PanelChild1MouvCam.Visibility = Visibility.Visible;
            }
            else
            {
                PanelChild1MouvCam.Visibility = Visibility.Collapsed;
            }
        }
        //Child1AxeCam
        private void buttonChild1AxeCam_Click(object sender, RoutedEventArgs e)
        {
            if (PanelChild1AxeCam.Visibility == Visibility.Collapsed)
            {
                PanelChild1AxeCam.Visibility = Visibility.Visible;
            }
            else
            {
                PanelChild1AxeCam.Visibility = Visibility.Collapsed;
            }
        }

        private void buttonChild1AxeCam_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (PanelChild1AxeCam.Visibility == Visibility.Collapsed)
            {
                PanelChild1AxeCam.Visibility = Visibility.Visible;
            }
            else
            {
                PanelChild1AxeCam.Visibility = Visibility.Collapsed;
            }
        }
        */
        
        #endregion

    
    }
}