using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using Microsoft.Surface;
using Microsoft.Surface.Presentation;
using Microsoft.Surface.Presentation.Controls;

using FingersDance.Control.UserPanel;
using FingersDance.Control.Screen;
using FingersDance.Control.Close;
using FingersDance.ViewModels;
using FingersDance.Data;


namespace FingersDance
{
    /// <summary>
    /// Interaction logic for SurfaceWindow1.xaml
    /// </summary>
    public partial class SurfaceWindow1 : SurfaceWindow
    {
        /// <summary>
        /// Default constructor.
        /// </summary>
        /// 
        #region Variables

        private UserControlUserPanel Panel1 = null;
        private UserControlUserPanel Panel2 = null;
        private UserControlUserPanel Panel3 = null;
        private UserControlUserPanel Panel4 = null;
        ActionFactory.ActionGenerator _Factory = new FingersDance.ActionFactory.ActionFactory().GetGenerator();
        private MainViewModel _mainviewmodel = new MainViewModel();      

        #endregion


        #region Constructor
        public SurfaceWindow1()
        {
            InitializeComponent();

            //Permet d'initialiser l'inertie du Pivot une fois relach.
            InitPivotInertia();
            //Permet d'initialiser les quand Grid  la position initiale du pivot
            InitGridPositions();
            // Add handlers for Application activation events
            AddActivationHandlers();
        }
        #endregion

        #region Initialization

        private void InitPivotInertia()
        {
            try
            {
                ScatterViewItem item = (ScatterViewItem)scaterview.Items.GetItemAt(0);
                item.DecelerationRate = double.NaN;
            }
            catch (Exception ex) { }
        }

        private void InitGridPositions()
        {
            //Initialise les 4 Grids  la positions initiale du Pivot.   
            try
            {
                ScatterViewItem item = (ScatterViewItem)scaterview.Items.GetItemAt(0);
                Grid1.Width =item.Center.X;
                Grid1.Height = item.Center.Y;
                
                Grid2.Width = item.Center.X;
                Grid2.Height = 768 - item.Center.Y;

                Grid3.Width = 1024 - item.Center.X;
                Grid3.Height = 768 - item.Center.Y;

                Grid4.Width = 1024 - item.Center.X;
                Grid4.Height = item.Center.Y;
            }
            catch (Exception ex) { }
        }

        #endregion

        /// <summary>
        /// Occurs when the window is about to close. 
        /// </summary>
        /// <param name="e"></param>
        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);

            // Remove handlers for Application activation events
            RemoveActivationHandlers();
        }

        /// <summary>
        /// Adds handlers for Application activation events.
        /// </summary>
        private void AddActivationHandlers()
        {
            // Subscribe to surface application activation events
            ApplicationLauncher.ApplicationActivated += OnApplicationActivated;
            ApplicationLauncher.ApplicationPreviewed += OnApplicationPreviewed;
            ApplicationLauncher.ApplicationDeactivated += OnApplicationDeactivated;
        }

        /// <summary>
        /// Removes handlers for Application activation events.
        /// </summary>
        private void RemoveActivationHandlers()
        {
            // Unsubscribe from surface application activation events
            ApplicationLauncher.ApplicationActivated -= OnApplicationActivated;
            ApplicationLauncher.ApplicationPreviewed -= OnApplicationPreviewed;
            ApplicationLauncher.ApplicationDeactivated -= OnApplicationDeactivated;
        }

        /// <summary>
        /// This is called when application has been activated.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationActivated(object sender, EventArgs e)
        {
            //TODO: enable audio, animations here

        }

        /// <summary>
        /// This is called when application is in preview mode.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationPreviewed(object sender, EventArgs e)
        {
            //TODO: Disable audio here if it is enabled

            //TODO: optionally enable animations here
        }

        /// <summary>
        ///  This is called when application has been deactivated.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnApplicationDeactivated(object sender, EventArgs e)
        {
            //TODO: disable audio, animations here
        }

        /// <summary>
        ///  This is called when application has been loaded, we change the orientation
        ///  of the application
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void mainSurfaceWindow_Loaded(object sender, RoutedEventArgs e)
        {

            if (ApplicationLauncher.InitialOrientation == UserOrientation.Top)
            {
                // Rotate the main canvas by 180 degrees.
                this.MainGrid.LayoutTransform = new RotateTransform(180.0);
            }
            else
            {
                // Remove the rotate transform on the main canvas.
                this.MainGrid.LayoutTransform = null;
            }
            // Dismiss the loading screen.
            ApplicationLauncher.SignalApplicationLoadComplete();
        }

        private void scaterview_ContactChanged(object sender, ContactEventArgs e)
        {  }

        private void ScatterViewItemPivot_ContactChanged(object sender, ContactEventArgs e)
        {
            //Permet la MAJ des 4 Grids  la position du pivot
            try
            {
                Grid1.Width = e.GetPosition(mainSurfaceWindow).X;
                Grid1.Height = e.GetPosition(mainSurfaceWindow).Y;

                Grid3.Width = e.GetPosition(mainSurfaceWindow).X;
                Grid3.Height = 768 - e.GetPosition(mainSurfaceWindow).Y;

                Grid4.Width = 1024 - e.GetPosition(mainSurfaceWindow).X;
                Grid4.Height = 768 - e.GetPosition(mainSurfaceWindow).Y;

                Grid2.Width = 1024 - e.GetPosition(mainSurfaceWindow).X;
                Grid2.Height = e.GetPosition(mainSurfaceWindow).Y;

                //GRISAGE
                //Grid1
                if (Grid1.Width < (1024 / 4) || Grid2.Height < (768 / 4))
                {
                    try
                    {
                        if (Panel1 != null)
                            Panel1.PlayerPause();
                        Grid1.Children[1].Visibility = Visibility.Hidden;
                    }
                    catch (Exception) { }
                }
                else
                {
                    try
                    { 
                        Grid1.Children[1].Visibility = Visibility.Visible; 
                    }
                    catch (Exception) { }
                }
                //Grid2
                if (Grid2.Width < (1024 / 4) || Grid2.Height < (768 / 4))
                {
                    try
                    {
                        if (Panel2 != null)
                            Panel2.PlayerPause();
                        Grid2.Children[1].Visibility = Visibility.Hidden; 
                    }
                    catch (Exception) { }
                }
                else
                {
                    try
                    {
                        Grid2.Children[1].Visibility = Visibility.Visible; 
                    }
                    catch (Exception) { }
                }
                //Grid3
                if (Grid3.Width < (1024 / 4) || Grid3.Height < (768 / 4))
                {
                    try
                    {
                        if (Panel3 != null)
                            Panel3.PlayerPause();
                        Grid3.Children[1].Visibility = Visibility.Hidden;
                    }
                    catch (Exception) { }
                }
                else
                {
                    try
                    {
                        Grid3.Children[1].Visibility = Visibility.Visible; 
                    }
                    catch (Exception) { }
                }
                //Grid4
                if (Grid4.Width < (1024 / 4) || Grid4.Height < (768 / 4))
                {
                    try
                    {
                        if (Panel4 != null)
                            Panel4.PlayerPause();
                        Grid4.Children[1].Visibility = Visibility.Hidden;
                    }
                    catch (Exception) { }
                }
                else
                {
                    try
                    { 
                        Grid4.Children[1].Visibility = Visibility.Visible;
                    }
                    catch (Exception) { }
                }
            }
            catch (Exception) { }
        }

        private void UserControlPivot_EH_SurfaceButtonPlayer_ContactDown(object sender, EventArgs e)
        {
            //  Si aucune video n'a t slectionne et qu'une grid contient un lment (listvideo), on ne fait rien
            if (_mainviewmodel.Session.Name.Equals("") && (Grid1.Children.Count == 2 || Grid2.Children.Count == 2 || Grid3.Children.Count == 2 || Grid4.Children.Count == 2))
                return;

            //  Traitement du contact down sur le pivot (Cration d'un screen ou suppression d'un panel
            switch ((int)sender)
            {
                case 1:
                    if (Panel1 == null && Grid1.Children.Count == 1)
                    {
                        //1-Creation du control Screen
                        UserControlScreen Screen = new UserControlScreen(1, _mainviewmodel);
                        Screen.Name = "Screen1";
                        Screen.contexteGrid = Grid1.Name.ToString();
                        //2-Rajout du screen dans la grid correspondante
                        Grid1.Children.Add(Screen);

                        Screen.UC_Screen_NewSession += new System.EventHandler(this.SessionInput_EH_SurfaceButtonSubmit_ContactDown);
                    }
                    else //Affichage du message de confirmation
                    {
                        if (Panel1 != null && Grid1.Children.Count == 2)
                        {
                            UserControlClose UCclose = new UserControlClose(1, "tes-vous sr de vouloir quitter ?");
                            UCclose.Name = "CloseAlert1";
                            Grid1.Children.Add(UCclose);
                            UCclose.ConfirmYesOrNo += new EventHandler<ConfirmEventArgs>(CloseAlert_EH_SurfaceButton_ContactDown);
                        }
                    }
                    break;
                case 2:
                    if (Panel2 == null && Grid2.Children.Count == 1)
                    {
                        //1-Creation du control Screen
                        UserControlScreen Screen = new UserControlScreen(2, _mainviewmodel);
                        Screen.Name = "Screen2";
                        Screen.contexteGrid = Grid2.Name.ToString();
                        //2-Rajout du screen dans la grid correspondante
                        Grid2.Children.Add(Screen);

                        Screen.UC_Screen_NewSession += new System.EventHandler(this.SessionInput_EH_SurfaceButtonSubmit_ContactDown);
                    }
                    else //Affichage du message de confirmation
                    {
                        if (Panel2 != null && Grid2.Children.Count == 2)
                        {
                            UserControlClose UCclose = new UserControlClose(2, "tes-vous sr de vouloir quitter ?");
                            UCclose.Name = "CloseAlert2";
                            Grid2.Children.Add(UCclose);
                            UCclose.ConfirmYesOrNo += new EventHandler<ConfirmEventArgs>(CloseAlert_EH_SurfaceButton_ContactDown);
                        }
                    }
                    break;
                case 3:
                    if (Panel3 == null && Grid3.Children.Count == 1)
                    {
                        //1-Creation du control Screen
                        UserControlScreen Screen = new UserControlScreen(3, _mainviewmodel);
                        Screen.Name = "Screen3";
                        Screen.contexteGrid = Grid3.Name.ToString();
                        //2-Rajout du screen dans la grid correspondante
                        Grid3.Children.Add(Screen);

                        Screen.UC_Screen_NewSession += new System.EventHandler(this.SessionInput_EH_SurfaceButtonSubmit_ContactDown);
                    }
                    else //Affichage du message de confirmation
                    {
                        if (Panel3 != null && Grid3.Children.Count == 2)
                        {
                            UserControlClose UCclose = new UserControlClose(3, "tes-vous sr de vouloir quitter ?");
                            UCclose.Name = "CloseAlert3";
                            Grid3.Children.Add(UCclose);
                            UCclose.ConfirmYesOrNo += new EventHandler<ConfirmEventArgs>(CloseAlert_EH_SurfaceButton_ContactDown);
                        }
                    }
                    break;
                case 4:
                    if (Panel4 == null && Grid4.Children.Count == 1)
                    {
                        //1-Creation du control Screen
                        UserControlScreen Screen = new UserControlScreen(4, _mainviewmodel);
                        Screen.Name = "Screen4";
                        Screen.contexteGrid = Grid4.Name.ToString();
                        //2-Rajout du screen dans la grid correspondante
                        Grid4.Children.Add(Screen);

                        Screen.UC_Screen_NewSession += new System.EventHandler(this.SessionInput_EH_SurfaceButtonSubmit_ContactDown);
                    }
                    else //Affichage du message de confirmation
                    {
                        if (Panel4 != null && Grid4.Children.Count == 2)
                        {
                            UserControlClose UCclose = new UserControlClose(4, "tes-vous sr de vouloir quitter ?");
                            UCclose.Name = "CloseAlert4";
                            Grid4.Children.Add(UCclose);
                            UCclose.ConfirmYesOrNo += new EventHandler<ConfirmEventArgs>(CloseAlert_EH_SurfaceButton_ContactDown);
                        }
                    }
                    break;
            }
                        
        }

        //Button Submit du control SessionInput
        private void SessionInput_EH_SurfaceButtonSubmit_ContactDown(object sender, EventArgs e)
        {
            try
            {
                //1-Suppression du UC Screen
                Grid root = (Grid)(((UserControlScreen)sender).Parent);
                root.Children.Remove(((UserControlScreen)sender));

                if (((UserControlScreen)sender).Project != null)
                {
                    //2-Creation du User Panel
                    Project newProject = ((UserControlScreen)sender).Project.Project;

                    if ((Panel1 != null && Panel1.Project.Equals(newProject)) || (Panel2 != null && Panel2.Project.Equals(newProject)) || (Panel3 != null && Panel3.Project.Equals(newProject)) || (Panel4 != null && Panel4.Project.Equals(newProject)))
                        return;

                    switch (((UserControlScreen)sender).id)
                    {
                        case 1:
                            Panel1 = new UserControlUserPanel(1, 0xFF5A0FC8, newProject, _mainviewmodel.Session.VideoPath);
                            Panel1.Name = "UserPanel1";
                            //3-Rajout sur la Grid Root
                            root.Children.Add(Panel1);
                            break;
                        case 2:
                            Panel2 = new UserControlUserPanel(2, 0xFFC80FA0, newProject, _mainviewmodel.Session.VideoPath);
                            Panel2.Name = "UserPanel2";
                            //3-Rajout sur la Grid Root
                            root.Children.Add(Panel2);
                            break;
                        case 3:
                            Panel3 = new UserControlUserPanel(3, 0xFFFFFF00, newProject, _mainviewmodel.Session.VideoPath);
                            Panel3.Name = "UserPanel3";
                            //3-Rajout sur la Grid Root
                            root.Children.Add(Panel3);
                            break;
                        case 4:
                            Panel4 = new UserControlUserPanel(4, 0xFF0096FF, newProject, _mainviewmodel.Session.VideoPath);
                            Panel4.Name = "UserPanel4";
                            //3-Rajout sur la Grid Root
                            root.Children.Add(Panel4);
                            break;
                    }
                }
            }
            catch (Exception ex) { }
        }

        //Actions du boutton Alert selon l'action close OK ou NON
        private void CloseAlert_EH_SurfaceButton_ContactDown(object sender, ConfirmEventArgs e)
        {
            Grid root = (Grid)(((UserControlClose)sender).Parent);
            if(e.Confirmed==true)
            {
                switch(e.PanelNumber)
                {
                    case 1:
                        root.Children.Remove(Panel1);
                        Panel1 = null;
                        break;
                    case 2:
                        root.Children.Remove(Panel2);
                        Panel2 = null;
                        break;
                    case 3:
                        root.Children.Remove(Panel3);
                        Panel3 = null;
                        break;
                    case 4:
                        root.Children.Remove(Panel4);
                        Panel4 = null;
                        break;
                }
            }
            root.Children.Remove(((UserControlClose)sender));
        }

    }
}