﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using FingersDance.Data;

namespace FingersDance.ViewModels
{
    public class AnnotationViewModel : ViewModelBase
    {
        private float _tcBegin;
        private float _dur;
        private String _gestureType;

        public AnnotationViewModel(Annotation a) {
            this._tcBegin = a.TcBegin;
            this._dur = a.Dur;
            this._gestureType = a.GestureType;
        }

        public float TcBegin
        {
            get { return _tcBegin; }
            set {
                if (value == _tcBegin || float.IsNaN(value))
                    return;
                _tcBegin = value;
                base.OnPropertyChanged("TcBegin");
            }
        }
        public float Dur
        {
            get { return _dur; }
            set
            {
                if (value == _dur || float.IsNaN(value))
                    return;
                _dur = value;
                base.OnPropertyChanged("Dur");
            }
        }
        public String GestureType
        {
            get { return _gestureType; }
            set
            {
                if (value == _gestureType || String.IsNullOrEmpty(value))
                    return;
                _gestureType = value;
                base.OnPropertyChanged("GestureType");
            }
        }

    }
}
