﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Media;

namespace FingersDance.Data
{
    public class Annotation
    {
        private String _id;
        private float _tcBegin;
        private float _dur;
        private List<String> _gestureType;
        private Color _color;

        public Annotation(String idPar, float tcBeginPar, float durPar, List<String> gesturePar, Color colorPar)
        {
            this._id = idPar;
            this._tcBegin = tcBeginPar;
            this._dur = durPar;
            this._gestureType = gesturePar;
            this._color = colorPar;
        }

        public String Id
        {
            get { return _id; }
            set
            {
                if (value == _id || String.IsNullOrEmpty(value))
                    return;
                _id = value;
            }
        }
        public float TcBegin
        {
            get { return _tcBegin; }
            set
            {
                if (value == _tcBegin || float.IsNaN(value))
                    return;
                _tcBegin = value;
            }
        }
        public float Dur
        {
            get { return _dur; }
            set
            {
                if (value == _dur || float.IsNaN(value))
                    return;
                _dur = value;
            }
        }
        public List<String> GestureType
        {
            get { return _gestureType; }
            set
            {
                if (value == _gestureType)
                    return;
                _gestureType = value;
            }
        }
        public Color Color
        {
            get { return _color; }
            set
            {
                if (value == _color)
                    return;
                _color = value;
            }
        }

    }

}
