﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Media;

namespace FingersDance.Factory
{
    public class ColorFactory
    {

        static Dictionary<uint, string> _ColorsStringId;
        static Dictionary<uint, Color> _Colors;

        public Dictionary<uint, string> ColorsStringId
        {
            get { return _ColorsStringId; }
        }
        public Dictionary<uint, Color> Colors
        {
            get { return _Colors; }
        }

        public ColorFactory()
        {
            if (_ColorsStringId == null)
            {
                _ColorsStringId = new Dictionary<uint, string>();
                _ColorsStringId.Add(0, "DefaultColor_xaml");
                _ColorsStringId.Add(1, "Color_1_#FFFF00_xaml");
                _ColorsStringId.Add(2, "Color_2_#FFC800_xaml");
                _ColorsStringId.Add(3, "Color_3_#FF7D00__xaml");
                _ColorsStringId.Add(4, "Color_4_#FF0000_xaml");
                _ColorsStringId.Add(5, "Color_5_#FF0064_xaml");
                _ColorsStringId.Add(6, "Color_6_#C80FA0_xaml");
                _ColorsStringId.Add(7, "Color_7_#5A0FC8_xaml");
                _ColorsStringId.Add(8, "Color_8_#230FD2_xaml");
                _ColorsStringId.Add(9, "Color_9_#0096FF__xaml");
                _ColorsStringId.Add(10, "Color_10_#009664_xaml");
                _ColorsStringId.Add(11, "Color_11_#006432_xaml");
                _ColorsStringId.Add(12, "Color_12_#00C800_xaml");
            }

            if (_Colors == null)
            {
                _Colors = new Dictionary<uint, Color>();
                _Colors.Add(0, Color.FromRgb(0x88, 0x88, 0x88));
                _Colors.Add(1, Color.FromRgb(0xFF, 0xFF, 0x00));
                _Colors.Add(2, Color.FromRgb(0xFF, 0xC8, 0x00));
                _Colors.Add(3, Color.FromRgb(0xFF, 0x7D, 0x00));
                _Colors.Add(4, Color.FromRgb(0xFF, 0x00, 0x00));
                _Colors.Add(5, Color.FromRgb(0xFF, 0x00, 0x64));
                _Colors.Add(6, Color.FromRgb(0xC8, 0x0F, 0xA0));
                _Colors.Add(7, Color.FromRgb(0x5A, 0x0F, 0xC8));
                _Colors.Add(8, Color.FromRgb(0x23, 0x0F, 0xD2));
                _Colors.Add(9, Color.FromRgb(0x00, 0x96, 0xFF));
                _Colors.Add(10, Color.FromRgb(0x00, 0x96, 0x64));
                _Colors.Add(11, Color.FromRgb(0x00, 0x64, 0x32));
                _Colors.Add(12, Color.FromRgb(0x00, 0xC8, 0x00));
            }
        }
    }
}
