﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;

namespace FingersDance.Control.SyncSource
{
	public partial class UserControlSyncSource
	{
		public UserControlSyncSource()
		{
			this.InitializeComponent();

			// Insert code required on object creation below this point.
		}


        #region player
        private void UserControlPlayer_PlayerOpened(object sender, EventArgs e)
        {
            //Initialisation du Timer
            UserControlTimeLine.initTimer();
            //Initialisation du slider
            UserControlTimeLine.initslider(UserControlPlayer.TotalMilliseconds);
            //Demarrage du Timer
            UserControlTimeLine.timerStart();

        }
        #endregion

        #region TimeLine


        private void UserControlTimeLine_DragStarted(object sender, EventArgs e)
        {
            UserControlPlayer.playerPause();
        }


        private void UserControlTimeLine_DragCompleted(object sender, EventArgs e)
        {
        }
        #endregion


        #region SynSource pour chaque X milliseconds
        private void UserControlTimeLine_TimerTick(object sender, EventArgs e)
        {
            if (!UserControlTimeLine.IsDragging)
            {
                UserControlTimeLine.Slider.Value = UserControlPlayer.Player.Position.TotalMilliseconds;
            }
            if (UserControlTimeLine.FinishedDragging)
            {
                int SliderValue = (int)UserControlTimeLine.Slider.Value;
                TimeSpan ts = new TimeSpan(0, 0, 0, 0, SliderValue);

                UserControlPlayer.Player.Position = ts;
                UserControlPlayer.playerPlay();

                UserControlTimeLine.IsDragging = false;
                UserControlTimeLine.FinishedDragging = false;
            }
        }
        #endregion
    }
}