﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.Reflection;

namespace FingersDance.Control.ListVideo
{
    public class ListVideo
    {
        static Dictionary<string, ListVideoItem> _Videos;

        public ListVideo()
        { }

        public Dictionary<string, ListVideoItem> GetVideos()
        {
            if (_Videos == null)
            {
                _Videos = new Dictionary<string, ListVideoItem>();
                LoadList();
            }
            return _Videos;
        }

        void LoadList()
        {
            _Videos.Clear();
            StreamReader reader = null;
            FileInfo assemblyPath = new FileInfo(Assembly.GetExecutingAssembly().Location);
            DirectoryInfo info = assemblyPath.Directory;
            try
            {
                reader = new StreamReader(info.FullName.ToString() + "\\Resources\\videos.xml");
                XmlSerializer serializer = new XmlSerializer(typeof(List<ListVideoItem>));
                List<ListVideoItem> temp = (List<ListVideoItem>)serializer.Deserialize(reader);
                foreach (ListVideoItem elt in temp)
                    if (!elt.Preview.Equals("") && !_Videos.ContainsKey(elt.Path))
                        _Videos.Add(elt.Path, elt);
                reader.Close();
            }
            catch (Exception e)
            {
                if (reader != null)
                    reader.Close();
            }
        }
    }
}
