﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

using FingersDance.Data;
using FingersDance.ViewModels;
using FingersDance.Views;

namespace FingersDance.Views
{
    /// <summary>
    /// Interaction logic for TimelineView.xaml
    /// </summary>
    public partial class TimelineView : UserControl
    {

        public TimelineView()
        {
            InitializeComponent();
        }

        public Double ScaleX
        {
            get { return ((ScaleTransform)listview.RenderTransform).ScaleX; }
            set{
                // We set the scale to the list view
                listview.RenderTransform = new ScaleTransform(value, 1);
                // We inform each annotation that scale has been changed
                foreach (AnnotationViewModel a in listview.Items)
                {
                    //Console.WriteLine("a = " + a);
                    a.ScaleX = 1 / value;
                }
            }
        }
        
    }
}
