﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using FingersDance.Control.TimeLine;
using FingersDance.ViewModels;

namespace FingersDance.Control.SyncSource
{
	public partial class UserControlSyncSource
	{
        #region Variables   
            public event EventHandler OnSuccessAnnotation;
        #endregion

		public UserControlSyncSource()
		{
			this.InitializeComponent();

			// Insert code required on object creation below this point.
		}

        public void Load(string path, Color col, CuttingViewModel cutVM)
        {
            this.UserControlPlayer.initPlayer(path);
            //Initialisation du Timer
            UCTimeLine.initTimer(col, cutVM);
            this.UserControlPlayer.playerPlay();
            this.userControlTimeLine.OnSuccessAnnotation+=new EventHandler(userControlTimeLine_OnSuccessAnnotation);
            this.UserControlPlayer.PlayerStopOrPause +=new EventHandler(UserControlPlayer_PlayerStopOrPause);
        }

        #region player
        private void UserControlPlayer_PlayerOpened(object sender, EventArgs e)
        {
            //Initialisation du slider
            UCTimeLine.initslider(UserControlPlayer.TotalMilliseconds);
            //Demarrage du Timer
            UCTimeLine.timerStart();

        }

        //Set a bursh color to the stack panel in the Player
        public void UserControlPlayer_DisplayAnnotation(int id, Brush b)
        {
            UserControlPlayer.displayStackPanelAnnotations(id, b);

        }
        public void UserControlPlayer_PlayerStopOrPause(object sender, EventArgs e)
        {
            try
            {
                userControlTimeLine.thumbRotation((bool)sender);
            }catch(Exception ){}
        }
        #endregion

        #region TimeLine


        private void UserControlTimeLine_DragStarted(object sender, EventArgs e)
        {
            UserControlPlayer.playerPause();
        }


        private void UserControlTimeLine_DragCompleted(object sender, EventArgs e)
        {
        }
        private void userControlTimeLine_OnSuccessAnnotation(object sender, EventArgs e)
        {
            OnSuccessAnnotation(this, new EventArgs());
        }

        #endregion


        #region SynSource pour chaque X milliseconds
        private void UserControlTimeLine_TimerTick(object sender, EventArgs e)
        {
            if (!UCTimeLine.IsDragging)
            {
                UCTimeLine.Slider.Value = UserControlPlayer.Player.Position.TotalMilliseconds;
            }
            if (UCTimeLine.FinishedDragging)
            {
                int SliderValue = (int)UCTimeLine.Slider.Value;
                TimeSpan ts = new TimeSpan(0, 0, 0, 0, SliderValue);

                UserControlPlayer.Player.Position = ts;
                UserControlPlayer.playerPlay();

                UCTimeLine.IsDragging = false;
                UCTimeLine.FinishedDragging = false;
            }
        }
        #endregion

        public UserControlTimeLine userControlTimeLine
        {
            get { return this.UCTimeLine; }
        }

        public void PlayerPause()
        {
            UserControlPlayer.playerPause();
        }
    }
}