﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FingersDance.Control.Player;
using FingersDance.Actions;

namespace FingersDance.ActionFactory
{
    public class ActionFactory
    {
        private Dictionary<String, Type> actionDict = new Dictionary<string, Type>();

        public ActionFactory()
        {
            actionDict.Add("ActionPlayMedia", typeof(FingersDance.Actions.ActionPlayMedia));
            actionDict.Add("ActionShowMessage", typeof(FingersDance.Actions.ActionShowMessage));
            actionDict.Add("ActionOpenMedia", typeof(FingersDance.Actions.ActionOpenMedia));
            actionDict.Add("ActionStopMedia", typeof(FingersDance.Actions.ActionStopMedia));            
        }

        public ActionBase GetAction(string T, object Args)
        {
            return (ActionBase)Activator.CreateInstance(actionDict[T]);
        }
    }
}
