﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using FingersDance.Data;
using Microsoft.Surface.Presentation;
using System.Globalization;
using Microsoft.Surface.Presentation.Controls;
using System.Reflection;
using FingersDance.ViewModels;

namespace FingersDance.Control.UserPanel
{
	public partial class UserControlUserPanel
	{
        #region Variables

        //public ContactEventHandler ContactDown;
        public event EventHandler OnSuccessAnnotation;  //Event to display ColorAnnotation from different Users        
        public int id = 0;
        public uint idcolor = 0;    //The color of the Pivot Button
        //Project _Project = new Project();
        private CuttingViewModel cutVM;

        #endregion

        #region Properties
        public CuttingViewModel CuttingVM
        {
            get { return cutVM; }
            set { cutVM = value; }
        }
        #endregion

        //#region Properties
        //public Project Project
        //{
        //    get { return _Project; }
        //    set { _Project = value; }
        //}
        //#endregion

        #region Constructors
        public UserControlUserPanel()
		{
			this.InitializeComponent();

			// Insert code required on object creation below this point.
		}

        public UserControlUserPanel(int idPar, Color col, Cutting cut, string path)
        {
            this.InitializeComponent();
            id = idPar;
            //_Project = p;
            this.UserControlSyncSource.Load(path, col, cut);
            UserControlSyncSource.OnSuccessAnnotation+=new EventHandler(UserControlSyncSource_OnSuccessAnnotation);
            //SAR -Contact Down event for TAG Control
            InitializeDefinitions();
        }

        private void InitializeDefinitions() 
        { 
            for (byte k = 1; k <= 5; k++)
            { 
                ByteTagVisualizationDefinition tagDef = new ByteTagVisualizationDefinition(); 
                // The tag value that this definition will respond to. 
                tagDef.Value = k; 
                // The .xaml file for the UI. 
                tagDef.Source = new Uri("FingersDance.Control.UserPanel;Component/TagVisuSoundControl.xaml", UriKind.Relative);

                // The maximum number for this tag value. tagDef.MaxCount = 2; 
                // The visualization stays for 2 seconds after the tag is lifted. 
                tagDef.LostTagTimeout = 2000.0; 
                // The orientation offset (default). 
                tagDef.OrientationOffsetFromTag = 0.0; 
                // The physical offset (horizontal inches, vertical inches). 
                tagDef.PhysicalCenterOffsetFromTag = new Vector(0.5, 0.25); 
                // The tag removal behavior (default). 
                tagDef.TagRemovedBehavior = TagRemovedBehavior.Fade; 
                // Orient UI to tag? (default). 
                tagDef.UsesTagOrientation = true; 
                // Add the definition to the collection. 
                this.tagVisualizer.Definitions.Add(tagDef); 
            } 
        }

        private void OnVisualizationAdded(object sender, TagVisualizerEventArgs e) 
        { 
            TagVisuSoundControl tagsoundcontrol = (TagVisuSoundControl)e.TagVisualization; 
            switch (tagsoundcontrol.VisualizedTag.Byte.Value) 
            {
                case 1: tagsoundcontrol.volumeModel.Content = "Tag Value 1"; 
                break;
                case 2: tagsoundcontrol.volumeModel.Content = "Tag Value 2"; 
                break;
                case 3: tagsoundcontrol.volumeModel.Content = "Tag Value 3"; 
                break;
                case 4: tagsoundcontrol.volumeModel.Content = "Tag Value 4"; 
                break;
                case 5: tagsoundcontrol.volumeModel.Content = "Tag Value 5"; 
                break;
                default: tagsoundcontrol.volumeModel.Content = "UNKNOWN MODEL"; 
                break; 
            } 
        }
        #endregion

        public void PlayerPause()
        {
            UserControlSyncSource.PlayerPause();
        }


        private void UserControlSyncSource_OnSuccessAnnotation(object sender, EventArgs e)
        {
            OnSuccessAnnotation(this, new EventArgs());
        }

        public void UserControlSyncSource_DisplayAnnotation(int id, Brush b)
        {
            UserControlSyncSource.UserControlPlayer_DisplayAnnotation(id, b);
        }

        //SAR
        public void UserControlUserPanel_ContactDown(object sender, ContactEventArgs e)
        {
            Contact c = e.Contact;
            string type = "";
            if (c.Tag.Type == TagType.Byte)
            {
                type = "Byte Tag";
                type += (" Value: " + c.Tag.Byte.Value.ToString("X", CultureInfo.InvariantCulture));
            }
            else if (c.Tag.Type == TagType.Identity)
            {
                type = "Identity Tag";
                type += (" Value: " + c.Tag.Byte.Value.ToString("X", CultureInfo.InvariantCulture));
            }
        }

        private void tagVisualizer_VisualizationAdded(object sender, Microsoft.Surface.Presentation.Controls.TagVisualizerEventArgs e)
        {

        }

        private void v(object sender, Microsoft.Surface.Presentation.Controls.TagVisualizerEventArgs e)
        {

        }

        
    }
}