﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Media;

namespace FingersDance.Data
{
    public class Annotation
    {
        private float _tcBegin;
        private float _dur;
        private string _gestureType;
        private Color _color;

        public Annotation(float tcBeginPar, float durPar, string gesturePar, Color colorPar)
        {
            this._tcBegin = tcBeginPar;
            this._dur = durPar;
            this._gestureType = gesturePar;
            this._color = colorPar;
        }

        public float TcBegin
        {
            get { return _tcBegin; }
            set
            {
                if (value == _tcBegin || float.IsNaN(value))
                    return;
                _tcBegin = value;
            }
        }
        public float Dur
        {
            get { return _dur; }
            set
            {
                if (value == _dur || float.IsNaN(value))
                    return;
                _dur = value;
            }
        }
        public String GestureType
        {
            get { return _gestureType; }
            set
            {
                if (value == _gestureType || String.IsNullOrEmpty(value))
                    return;
                _gestureType = value;
            }
        }
        public Color Color
        {
            get { return _color; }
            set
            {
                if (value == _color)
                    return;
                _color = value;
            }
        }

    }

}
