﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using FingersDance.Data;
using FingersDance.Control;

namespace FingersDance.Control.SessionInput
{
    /// <summary>
    /// Interaction logic for UserControlListSession.xaml
    /// </summary>
    public partial class UserControlListSession
    {
        //Creation d'un Event pour Chaque Item Video
        public event EventHandler EH_List_ContactDown;
        public string SelectedItem = "";

        public UserControlListSession(List<Project> projects)
        {
            InitializeComponent();
            OpenProjects(projects);
        }

        private void OpenProjects(List<Project> projects)
        {
            CustomListBoxItem Contener = new CustomListBoxItem();
            Contener.Name = "New Project";
            UserControlCustomLabel l = new UserControlCustomLabel("New Project");
            Contener.Content = l;
            stackPanel.Children.Add(Contener);
            Contener.ContactTapGesture += Item_ContactTapGesture;
            foreach (Project elt in projects)
            {
                Contener = new CustomListBoxItem();
                Contener.Name = elt.Name;
                l = new UserControlCustomLabel(elt.Name);
                Contener.Content = l;
                stackPanel.Children.Add(Contener);
                Contener.ContactTapGesture += Item_ContactTapGesture;
            }
        }

        //Event appelé lors de la selection d'un Item dans la Liste
        private void Item_ContactTapGesture(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            SelectedItem = ((CustomListBoxItem)sender).Name;
            if (EH_List_ContactDown != null)
                EH_List_ContactDown(this, new EventArgs());
        }
    }
}
