﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using FingersDance.Control.ListVideo;
using FingersDance.Control.SessionInput;

namespace FingersDance.Control.Screen
{
	public partial class UserControlScreen
	{
        public String contexteGrid;
        public string Path = "";
        public int id = 0;
        public event EventHandler UC_Screen_NewSession;

		public UserControlScreen(int id)
		{
			this.InitializeComponent();
            this.id = id;
            //1-Creation de la ListVideo
            UserControlListVideo ListVideo = new UserControlListVideo();
            ListVideo.Name = "ListVideo1";

            //2-Ajout de la ListVideo au ControlScreen
            this.AddToGrid(ListVideo);

            //3-Creation des Events pour chaque item de la video
            ListVideo.EH_ItemVideo1_ContactDown += new System.EventHandler(this.ListVideo_EH_ItemVideo_ContactDown);
		}

        //Rajout un UIElement vers la grid du screen.
        public void AddToGrid(UIElement uie)
        {
            if (uie != null)
            {
                try { LayoutRoot.Children.Add(uie); }
                catch(Exception){}
            }          
        }

        private void ListVideo_EH_ItemVideo_ContactDown(object sender, EventArgs e)
        {

            //Creation d'un ScatterView Item
            //ScatterViewItem scatterViewItemSessionInput = new ScatterViewItem();
            //scatterViewItemSessionInput.Name = "ScatterViewItemSessionInput";


            //1-Creation d'une nouvelle seance.                
            UserControlSessionInput SessionInput = new UserControlSessionInput();
            SessionInput.Name = "SessionInput";

            try
            {
                //2-Recuperer la Grid (Layout root du UC screen)qui contient le UCListVideo et l'ajouter.
                
                LayoutRoot.Children.Add(SessionInput);

                //2.5 rensegner la video choisie au screen
                this.Path = ((UserControlListVideo)sender).path;
                //3-Creation des Events
                SessionInput.EH_SurfaceButtonSubmit_ContactDown += new System.EventHandler(this.SessionInput_EH_SurfaceButtonSubmit_ContactDown);
                //4-Supression du UC List Video
                LayoutRoot.Children.Remove((UserControlListVideo)sender);

                //Init Scatter View Properties and Add it to the scatter view.
                /*scatterViewItemSessionInput.Content = SessionInput;
                scatterViewItemSessionInput.CanMove = true;
                scatterViewItemSessionInput.CanScale = false;
                scatterViewItemSessionInput.CanRotate = true;
                scatterViewItemSessionInput.Center = new Point((double)actualGrid.ActualWidth,(double)actualGrid.ActualHeight);
                scaterview.Items.Add(scatterViewItemSessionInput);*/
            }
            catch (Exception ex) { }
        }

        private void SessionInput_EH_SurfaceButtonSubmit_ContactDown(object sender, EventArgs e)
        {
            try
            {
                //2-Suppression UCSession Input
                LayoutRoot.Children.Remove((UserControlSessionInput)sender);
                //3-Suppression du UC Screen
                if(UC_Screen_NewSession!=null)
                    UC_Screen_NewSession(this, new EventArgs());
            }
            catch (Exception ex) { }
        }
	}
}