﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using System.ComponentModel;
using System.Reflection;
using System.Collections.Generic;

using Microsoft.Surface.Presentation;
using Microsoft.Surface.Presentation.Controls;
using FingersDance.ActionFactory;
using FingersDance.Actions;
using FingersDance.Views;
using FingersDance.ViewModels;

namespace FingersDance.Control.Player
{
	public partial class UserControlPlayer
	{
        #region Variables
        private bool isPlaying = false;
        #endregion

        public event EventHandler PlayerOpened;

        public UserControlPlayer()
        {
            this.InitializeComponent();
            MediaElementVideo.LoadedBehavior = MediaState.Manual;
            MediaElementVideo.UnloadedBehavior = MediaState.Manual;
        }

        #region Properties
        public double TotalMilliseconds
        {
            get
            {
                return MediaElementVideo.NaturalDuration.TimeSpan.TotalMilliseconds;
            }
        }
        public MediaElement Player
        {
            get
            {
                return MediaElementVideo;
            }
            set
            {
                MediaElementVideo= value;
            }
        }

        #endregion


        #region Methodes

        public void initPlayer(string path)
        {
            //init player
            isPlaying = false;
            MediaElementVideo.Source = new Uri(path);
            MediaElementVideo.ScrubbingEnabled = true;
        }

        public void playerPause()
        {
            MediaElementVideo.Pause();
        }
        public void playerPlay()
        {
            MediaElementVideo.Play();
        }
        public void playerStop()
        {
            MediaElementVideo.Stop();
        }
        
        #endregion

        private void ButtonPlayPause_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (!isPlaying)//Play
            {
                isPlaying = true;
                try
                {
                    MediaElementVideo.Play();
                }
                catch (Exception ex) { }
            }
            else//Pause
            {
                isPlaying = false;
                try
                {
                    MediaElementVideo.Pause();
                }
                catch (Exception exx) { }
            }

        }

        private void ButtonPlayPause_Click(object sender, RoutedEventArgs e)
        {
            if (!isPlaying)//Play
            {
                isPlaying = true;
                try
                {
                    MediaElementVideo.Play();
                }
                catch (Exception ex) { }

            }
            else//Pause
            {
                isPlaying = false;
                try
                {
                    MediaElementVideo.Pause();
                }
                catch (Exception exx) { }
                //ButtonPlayPause.Background = FindResource("[Skin_1]_Play_button_xaml") as Brush;
            }
        }

        private void ButtonFastForward_Click(object sender, RoutedEventArgs e)
        {
            if (MediaElementVideo.SpeedRatio <= 3)
                MediaElementVideo.SpeedRatio += 1;
        }

        private void ButtonFastForward_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (MediaElementVideo.SpeedRatio <= 3)
                MediaElementVideo.SpeedRatio += 1;
        }

        private void ButtonRewind_Click(object sender, RoutedEventArgs e)
        {
            //TimeSpan ts = new TimeSpan(0, 0, 0, 0);
            if (MediaElementVideo.SpeedRatio > 1)
            {
                MediaElementVideo.SpeedRatio -= 1;
            }
            else
            {
                MediaElementVideo.Position = MediaElementVideo.Position.Add(new TimeSpan(0, 0, 0, -5));
            }
        }

        private void ButtonRewind_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {

            //TimeSpan ts = new TimeSpan(0, 0, 0,0);
            if (MediaElementVideo.SpeedRatio > 1)
            {
                MediaElementVideo.SpeedRatio -= 1;
            }
            else
            {
                MediaElementVideo.Position = MediaElementVideo.Position.Add(new TimeSpan(0, 0, 0, -5));
            }
        }

        private void MediaElementVideo_MediaOpened(object sender, RoutedEventArgs e)
        {
            OnPlayerOpened();
        }
        protected virtual void OnPlayerOpened()
        {
            if(PlayerOpened!=null)
                PlayerOpened(this, new EventArgs());
        }

        private void Play_Pause_area_DragEnter(object sender, SurfaceDragDropEventArgs e)
        {
            //Console.WriteLine("Enter");
            Play_Pause_area.Opacity = 0.5;
        }

        private void Play_Pause_area_DragLeave(object sender, SurfaceDragDropEventArgs e)
        {
            //Console.WriteLine("Leave");
            Play_Pause_area.Opacity = 0;
        }

        private void Play_Pause_area_DragOver(object sender, SurfaceDragDropEventArgs e)
        {
            //Console.WriteLine("Over");
        }

        private void Play_Pause_area_Drop(object sender, SurfaceDragDropEventArgs e)
        {
            //Console.WriteLine("Drop");
            Play_Pause_area.Opacity = 0;
            // e.Cursor.Visual is the ContentControl, so its Content is the dragged TimelineAnnotationView
            AnnotationViewModel annotationDataVM = (AnnotationViewModel)((TimelineAnnotationView)((ContentControl)e.Cursor.Visual).Content).DataContext;
            int nbSeconds = (int)annotationDataVM.TcBegin;
            int nbMilliSec = (int)((annotationDataVM.TcBegin * 1000)%1000);
            MediaElementVideo.Position = new TimeSpan(0, 0, 0, nbSeconds, nbMilliSec);


            // If the TimelineAnnotationView comes from a user control different from the current one, 
            // it means that we want to add the annotation to the current list.
            // So we generate the ActionAddAnnotation
            // e.Cursor.DragSource is the SurfaceListBox where the drag started from
            SurfaceListBox slb = (SurfaceListBox)e.Cursor.DragSource;
            // We get the instance of the UserControlSyncSource
            UserControl syncSrc = (UserControl)((Grid)((Grid)this.Parent).Parent).Parent;
            // and its UserControlTimeline
            UserControl tl = (UserControl)((Grid)((Grid)syncSrc.Content).Children[0]).Children[0];
            if (((Grid)((UserControl)((Grid)slb.Parent).Parent).Parent).Parent != tl)
            {
                // Now we build the action arguments : a list holding the timeline and the annotation view models
                List<Object> actionsArgs = new List<Object>();
                actionsArgs.Add(tl);
                actionsArgs.Add(annotationDataVM);

                ActionGenerator ag = new ActionGenerator();
                ActionBase ab = ag.GetAction("ActionAddAnnotation", actionsArgs);
                if (ab != null)
                    ab.Execute();
            }

        }
	}
}