﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using FingersDance.Data;

namespace FingersDance.Control.SessionInput
{
    /// <summary>
    /// Interaction logic for UserControlNewProject.xaml
    /// </summary>
    public partial class UserControlNewProject : UserControl
    {
        public event EventHandler EH_NewCutting_ContactDown;
        public Cutting Cutting = new Cutting();
        User _User = new User();

        public UserControlNewProject(User u)
        {
            InitializeComponent();
            ST_Date.Text = DateTime.Now.Day.ToString() + "/" + DateTime.Now.Month.ToString() + "/" + DateTime.Now.Year.ToString();
            _User = u;


        }

        #region Actions

        private void SurfaceButtonSubmit_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            Cutting = new Cutting(_User.Name, new List<Annotation>());   
            if (EH_NewCutting_ContactDown != null)
                EH_NewCutting_ContactDown(this, new EventArgs());
        }

        private void SurfaceButtonSubmit_Click(object sender, RoutedEventArgs e)
        {
            //Project = new Project(ST_ProjectName.Text, ST_Date.Text, ST_Desc.Text, _User, new Cutting());
            Cutting = new Cutting(_User.Name, new List<Annotation>());
            if (EH_NewCutting_ContactDown != null)
                EH_NewCutting_ContactDown(this, new EventArgs());   
        }

        #endregion
    }
}
