﻿using System;
using System.IO;
using System.Net;
using System.Collections.Generic;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using FingersDance.Control.ListVideo;
using FingersDance.Control.SessionInput;
using FingersDance.ViewModels;
using FingersDance.Data;

namespace FingersDance.Control.Screen
{
	public partial class UserControlScreen
	{
        public String contexteGrid;
        public int id = 0;
        public event EventHandler UC_Screen_NewCutting;
        public MainViewModel MainViewModel;
        public CuttingViewModel CuttingVM;
        private List<Project> existingProjects = new List<Project>();
        User User = new User();

        public UserControlScreen(int id, MainViewModel mvmodel)
        {
            try
            {
                this.InitializeComponent();
                this.id = id;
                User.Name = "User " + id;
                MainViewModel = mvmodel;
                if (MainViewModel.Project.VideoPath.Equals(""))
                {
                    //1-Creation de la ListVideo
                    UserControlListVideo ListVideo = new UserControlListVideo();
                    ListVideo.Name = "ListVideo1";
                    //2-Ajout de la ListVideo au ControlScreen
                    this.AddToGrid(ListVideo);
                    //3-Creation des Events pour chaque item de la video
                    ListVideo.EH_ItemVideo1_ContactDown += new System.EventHandler(this.ListVideo_EH_ItemVideo_ContactDown);
                }
                else
                    OpenProject();
            }
            catch (Exception)
            {
                CuttingVM = null;
                if (UC_Screen_NewCutting != null)
                    UC_Screen_NewCutting(this, new EventArgs());
            }
        }

        //Rajout un UIElement vers la grid du screen.
        public void AddToGrid(UIElement uie)
        {
            if (uie != null)
            {
                try { LayoutRoot.Children.Add(uie); }
                catch(Exception){}
            }          
        }

        private void ListVideo_EH_ItemVideo_ContactDown(object sender, EventArgs e)
        {
            try
            {
                //1 renseigner la video choisie au screen et créer un nouveau projet à partir de ce chemin vidéo
                MainViewModel.CreateProject(((UserControlListVideo)sender).VideoName, ((UserControlListVideo)sender).path);
                //2-Supression du UC List Video
                LayoutRoot.Children.Remove((UserControlListVideo)sender);
                OpenProjectList();
            }
            catch (Exception ex)
            {
                CuttingVM = null;
                if (UC_Screen_NewCutting != null)
                    UC_Screen_NewCutting(this, new EventArgs());
            }
        }

        private void OpenProjectList()
        {
            try
            {
                existingProjects = LoadProjects(MainViewModel.Project.VideoPath);
                UserControlListSession listProject = new UserControlListSession(existingProjects);
                listProject.Name = "ListProject";
                LayoutRoot.Children.Add(listProject);
                listProject.EH_List_ContactDown += new EventHandler(listProject_EH_List_ContactDown);
            }
            catch (Exception)
            {
                CuttingVM = null;
                if (UC_Screen_NewCutting != null)
                    UC_Screen_NewCutting(this, new EventArgs());
            }
        }

        private List<Project> LoadProjects(string name)
        {
            // Does nothing because for the moment we do not load sessions when we know the video path, we just create a new session
            try
            {
                return new List<Project>();
            }
            catch (Exception) 
            {
                return new List<Project>();
            }
        }

        void listProject_EH_List_ContactDown(object sender, EventArgs e)
        {
            try
            {
                LayoutRoot.Children.Remove((UserControlListSession)sender);
                if (((UserControlListSession)sender).SelectedItem.Equals("New Project"))
                {
                    UserControlSessionInput ProjectInput = new UserControlSessionInput();
                    ProjectInput.Name = "ProjectInput";
                    LayoutRoot.Children.Add(ProjectInput);
                    ProjectInput.EH_SurfaceButtonSubmit_ContactDown += new System.EventHandler(this.ProjectInput_EH_SurfaceButtonSubmit_ContactDown);
                }
                else
                {
                    foreach (Project elt in existingProjects)
                    {
                        if (elt.Name.Equals(((UserControlListSession)sender).SelectedItem))
                        {
                            MainViewModel.Project.Project = elt;
                            OpenProject();
                            return;
                        }
                    }
                }
            }
            catch (Exception)
            {
                CuttingVM = null;
                if (UC_Screen_NewCutting != null)
                    UC_Screen_NewCutting(this, new EventArgs());
            }
        }

        private void ProjectInput_EH_SurfaceButtonSubmit_ContactDown(object sender, EventArgs e)
        {
            try
            {
                //MainViewModel.Project.Alias = ((UserControlSessionInput)sender).Alias;
                //MainViewModel.Project.Email = ((UserControlSessionInput)sender).Email;
                MainViewModel.Project.Description = ((UserControlSessionInput)sender).Description;
                MainViewModel.Project.Name = ((UserControlSessionInput)sender).SessionName;
                
                
                //2-Suppression UCSession Input
                LayoutRoot.Children.Remove((UserControlSessionInput)sender);
                OpenProject();
            }
            catch (Exception ex) 
            {
                CuttingVM = null;
                if (UC_Screen_NewCutting != null)
                    UC_Screen_NewCutting(this, new EventArgs());
            }
        }

        private void OpenProject()
        {
            try
            {
                UserControlListProject listCuttings = new UserControlListProject(MainViewModel.Project.CuttingsDict);
                listCuttings.Name = "listCuttings";
                LayoutRoot.Children.Add(listCuttings);
                listCuttings.EH_Item_ContactDown += new EventHandler(listCuttings_EH_Item_ContactDown);
            }
            catch (Exception) 
            {
                CuttingVM = null;
                if (UC_Screen_NewCutting != null)
                    UC_Screen_NewCutting(this, new EventArgs());
            }
        }

        void listCuttings_EH_Item_ContactDown(object sender, EventArgs e)
        {
            try
            {
                LayoutRoot.Children.Remove((UserControlListProject)sender);
                if (((UserControlListProject)sender).SelectedItem.Equals("New Cutting"))
                {
                    UserControlNewProject newCutting = new UserControlNewProject(User);
                    newCutting.Name = "newCutting";
                    LayoutRoot.Children.Add(newCutting);
                    newCutting.EH_NewCutting_ContactDown += new EventHandler(newCutting_EH_ContactDown);
                }
                else
                {
                    foreach(KeyValuePair<string, Cutting> elt in MainViewModel.Project.CuttingsDict)
                        if (elt.Key.Equals(((UserControlListProject)sender).SelectedItem))
                        {
                            CuttingVM = new CuttingViewModel(elt.Value, 815);
                            if (UC_Screen_NewCutting != null)
                                UC_Screen_NewCutting(this, new EventArgs());
                            return;
                        }
                }
            }
            catch (Exception)
            {
                CuttingVM = null;
                if (UC_Screen_NewCutting != null)
                    UC_Screen_NewCutting(this, new EventArgs());
            }
        }

        void newCutting_EH_ContactDown(object sender, EventArgs e)
        {
            try
            {
                LayoutRoot.Children.Remove((UserControlNewProject)sender);
                CuttingVM = new CuttingViewModel(((UserControlNewProject)sender).Cutting, 850);
                MainViewModel.Project.CuttingsDict.Add(CuttingVM.Title, ((UserControlNewProject)sender).Cutting);
                if (UC_Screen_NewCutting != null)
                    UC_Screen_NewCutting(this, new EventArgs());
            }
            catch (Exception)
            {
                CuttingVM = null;
                if (UC_Screen_NewCutting != null)
                    UC_Screen_NewCutting(this, new EventArgs());
            }
        }
	}
}