﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using FingersDance.Data;

namespace FingersDance.ViewModels
{
    public class AnnotationViewModel : ViewModelBase
    {
        private float _tcBegin;
        private float _dur;
        private String _gestureType;

        private float _marginLeft;

        public AnnotationViewModel(Annotation a, float marginLeft) {
            this._tcBegin = a.TcBegin;
            this._dur = a.Dur;
            this._gestureType = a.GestureType;
            this._marginLeft = marginLeft;
        }

        public float TcBegin
        {
            get { return _tcBegin; }
            set {
                if (value == _tcBegin || float.IsNaN(value))
                    return;
                _tcBegin = value;
                base.OnPropertyChanged("TcBegin");
            }
        }
        public float Dur
        {
            get { return _dur; }
            set
            {
                if (value == _dur || float.IsNaN(value))
                    return;
                _dur = value;
                base.OnPropertyChanged("Dur");
            }
        }
        public String GestureType
        {
            get { return _gestureType; }
            set
            {
                if (value == _gestureType || String.IsNullOrEmpty(value))
                    return;
                _gestureType = value;
                base.OnPropertyChanged("GestureType");
            }
        }
        public float MarginLeft
        {
            get { return _marginLeft; }
            set
            {
                if (value == _marginLeft || float.IsNaN(value))
                    return;
                _marginLeft = value;
                base.OnPropertyChanged("MarginLeft");
            }
        }

    }
}
