﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using System.ComponentModel;
using System.Reflection;

namespace FingersDance.Control.Player
{
	public partial class UserControlPlayer
	{
        #region Variables
        private bool isPlaying = false;
        #endregion

        public event EventHandler PlayerOpened;

        public UserControlPlayer()
        {
            this.InitializeComponent();
            initPlayer();
        }

        public UserControlPlayer(string path)
        {
            this.InitializeComponent();
            initPlayer(path);
        }

        #region Properties
        public double TotalMilliseconds
        {
            get
            {
                return MediaElementVideo.NaturalDuration.TimeSpan.TotalMilliseconds;
            }
        }
        public MediaElement Player
        {
            get
            {
                return MediaElementVideo;
            }
            set
            {
                MediaElementVideo= value;
            }
        }

        #endregion


        #region Methodes
        void initPlayer()
        {
            //init player
            isPlaying = false;
            //Pour se diriger vers le Dossier ressources du projet et non le bin/ressources
            //DirectoryInfo info = Directory.GetParent(@".");
            FileInfo assemblyPath = new FileInfo(Assembly.GetExecutingAssembly().Location);
            DirectoryInfo info = assemblyPath.Directory;
            MediaElementVideo.Source = new Uri(@"" + info.FullName.ToString() + "\\Resources\\Lake.wmv", UriKind.Relative);
            MediaElementVideo.LoadedBehavior = MediaState.Manual;
            MediaElementVideo.UnloadedBehavior = MediaState.Manual;
            MediaElementVideo.ScrubbingEnabled= true;
        }

        public void initPlayer(string path)
        {
            //init player
            isPlaying = false;
            //Pour se diriger vers le Dossier ressources du projet et non le bin/ressources
            //DirectoryInfo info = Directory.GetParent(@".");
            MediaElementVideo.Source = new Uri(path, UriKind.Relative);
            MediaElementVideo.LoadedBehavior = MediaState.Manual;
            MediaElementVideo.UnloadedBehavior = MediaState.Manual;
            MediaElementVideo.ScrubbingEnabled = true;
        }

        public void playerPause()
        {
            MediaElementVideo.Pause();
        }
        public void playerPlay()
        {
            MediaElementVideo.Play();
        }
        public void playerStop()
        {
            MediaElementVideo.Stop();
        }
        
        #endregion

        private void ButtonPlayPause_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (!isPlaying)//Play
            {
                isPlaying = true;
                try
                {
                    MediaElementVideo.Play();
                }
                catch (Exception ex) { }
            }
            else//Pause
            {
                isPlaying = false;
                try
                {
                    MediaElementVideo.Pause();
                }
                catch (Exception exx) { }
            }

        }

        private void ButtonPlayPause_Click(object sender, RoutedEventArgs e)
        {
            if (!isPlaying)//Play
            {
                isPlaying = true;
                try
                {
                    MediaElementVideo.Play();
                }
                catch (Exception ex) { }

            }
            else//Pause
            {
                isPlaying = false;
                try
                {
                    MediaElementVideo.Pause();
                }
                catch (Exception exx) { }
                //ButtonPlayPause.Background = FindResource("[Skin_1]_Play_button_xaml") as Brush;
            }
        }

        private void ButtonFastForward_Click(object sender, RoutedEventArgs e)
        {
            if (MediaElementVideo.SpeedRatio <= 3)
                MediaElementVideo.SpeedRatio += 1;
        }

        private void ButtonFastForward_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (MediaElementVideo.SpeedRatio <= 3)
                MediaElementVideo.SpeedRatio += 1;
        }

        private void ButtonRewind_Click(object sender, RoutedEventArgs e)
        {
            //TimeSpan ts = new TimeSpan(0, 0, 0, 0);
            if (MediaElementVideo.SpeedRatio > 1)
            {
                MediaElementVideo.SpeedRatio -= 1;
            }
            else
            {
                MediaElementVideo.Position = MediaElementVideo.Position.Add(new TimeSpan(0, 0, 0, -5));
            }
        }

        private void ButtonRewind_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {

            //TimeSpan ts = new TimeSpan(0, 0, 0,0);
            if (MediaElementVideo.SpeedRatio > 1)
            {
                MediaElementVideo.SpeedRatio -= 1;
            }
            else
            {
                MediaElementVideo.Position = MediaElementVideo.Position.Add(new TimeSpan(0, 0, 0, -5));
            }
        }

        private void MediaElementVideo_MediaOpened(object sender, RoutedEventArgs e)
        {
            OnPlayerOpened();
        }
        protected virtual void OnPlayerOpened()
        {
            if(PlayerOpened!=null)
                PlayerOpened(this, new EventArgs());
        }
	}
}