﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace FingersDance.Data
{
    [Serializable]
    public class Project
    {
        private string _name = "";
        private string _date = "";
        private string _description = "";
        private User _user = new User();
        private Cutting _cutting = new Cutting();

        #region Constructor

        public Project(string name, string date, string desc, User u, Cutting c)
        {
            _date = date;
            _description = desc;
            _name = name;
            _user = u;
            _cutting = c;
        }

        public Project(User u, Cutting c)
        {
            _user = u;
            _cutting = c;
        }

        public Project()
        {}

        #endregion

        #region Properties

        public string Date
        {
            get { return _date; }
            set { _date = value; }
        }

        public string Name
        {
            get { return _name; }
            set { _name = value; }
        }

        public string Description
        {
            get { return _description; }
            set { _description = value; }
        }

        public User User
        {
            get { return _user; }
            set { _user = value; }
        }

        public Cutting Cutting
        {
            get { return _cutting; }
            set { _cutting = value; }
        }

        #endregion
    }

}
