﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using Microsoft.Surface;
using Microsoft.Surface.Presentation;
using System.Xml.Serialization;
using System.Reflection;

using FingersDance.Factory;
using FingersDance.Actions;
using FingersDance.Control.SyncSource;
using FingersDance.Control.TimeLine;

namespace FingersDance.Control.Menu
{
	public partial class UserControlMenu
	{
        private String _menuXmlFile = "menu.xml";

		public UserControlMenu()
		{
			this.InitializeComponent();
		}

        public String MenuXmlFile
        {
            get { return _menuXmlFile; }
            set
            {
                _menuXmlFile = value;
                initChildSize();
            }

        }

        //Premet de deplacer les sous menus vers la droite pour avoir un effect tree view
         private void initChildSize()
        {
            StreamReader reader = null;
            FileInfo assemblyPath = new FileInfo(Assembly.GetExecutingAssembly().Location);
            DirectoryInfo info = assemblyPath.Directory;
            try
            {
                reader = new StreamReader(info.FullName.ToString() + "\\Resources\\" + _menuXmlFile);
                XmlSerializer serializer = new XmlSerializer(typeof(Menu));
                Menu temp = (Menu)serializer.Deserialize(reader);
                foreach (Item elt in temp.Items)
                {
                    try
                    {
                        LayoutRoot.Children.Add(CreateMenuItem(elt));
                    }
                    catch (Exception) { }
                }
                reader.Close();
            }
            catch (Exception e)
            {
                // do nothing
            }
        }

         public StackPanel CreateMenuItem(Item item)
         {
             try
             {
                 StackPanel MItem = new StackPanel();
                 CustomSurfaceButton ItemButton = new CustomSurfaceButton();
                 ItemButton.Content = item.Name;
                 ItemButton.Style = (Style)FindResource(item.Ressource);
                 if (item.Items.Count > 0)
                 {
                     ItemButton.ContactDown += ButtonMenu_ContactDown;
                     ItemButton.Click += ButtonMenu_ContactDown;
                     ItemButton.ContactHoldGesture += new ContactEventHandler(ItemButton_ContactHoldGesture);
                     MItem.Children.Add(ItemButton);
                     StackPanel Temp = new StackPanel();
                     foreach (Item elt in item.Items)
                         try
                         {
                             Temp.Children.Add(CreateMenuItem(elt));
                         }
                         catch (Exception) { }
                     Temp.Name = ItemButton.Content.ToString().Replace(' ', '_') + "Panel";
                     Temp.Visibility = Visibility.Collapsed;
                     MItem.Children.Add(Temp);
                 }
                 else
                 {
                     ItemButton.ContactDown += ActionButton_ContactDown;
                     ItemButton.Click += ActionButton_ContactDown;
                     ItemButton.Action = item.Action;
                     MItem.Children.Add(ItemButton);
                 }
                 return MItem;
             }
             catch (Exception ex)
             {
                 throw ex;
             }
         }

         void ItemButton_ContactHoldGesture(object sender, ContactEventArgs e)
         {
             MessageBox.Show(((CustomSurfaceButton)sender).Action);
         }

         void ActionButton_ContactDown(object sender, RoutedEventArgs e)
         {
             // Generate action
             // We get the instance of the user panel
             UserControl userPanel = (UserControl)((Grid)((Grid)this.Parent).Parent).Parent;
             // Its content...
             Grid o = (Grid)userPanel.Content;
             // and the UserControlSyncSource within the grid...
             UserControlSyncSource syncSrc = (UserControlSyncSource)((Grid)o.Children[1]).Children[0];
             // and finally the timeline
             UserControlTimeLine tl = syncSrc.userControlTimeLine;

             String actionId = ((CustomSurfaceButton)sender).Action;
             ActionGenerator ag = new ActionGenerator();
             Object[] ar = new Object[2];
             ar[0] = tl;
             ar[1] = (String)((CustomSurfaceButton)sender).Content;
             ActionBase ab = ag.GetAction(actionId, ar);
             if(ab!=null)
                 ab.Execute();
         }

         private void ButtonMenu_ContactDown(object sender, RoutedEventArgs e)
         {
             foreach (UIElement Child in ((Panel)((CustomSurfaceButton)sender).Parent).Children)
             {
                 try
                 {
                     if (((StackPanel)Child).Name.Equals(((Microsoft.Surface.Presentation.Controls.SurfaceButton)sender).Content.ToString().Replace(' ', '_') + "Panel"))
                     {
                         if (((StackPanel)Child).Visibility == Visibility.Collapsed)
                         {
                             ((StackPanel)Child).Visibility = Visibility.Visible;
                         }
                         else
                         {
                             ((StackPanel)Child).Visibility = Visibility.Collapsed;
                         }
                         return;
                     }
                 }
                 catch (Exception ex) { }
             }
         }

         private void LayoutRoot_DragLeave(object sender, System.Windows.DragEventArgs e)
         {
             MessageBox.Show(((CustomSurfaceButton)sender).Action);
         }
    }
}