﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using FingersDance.Data;
using Microsoft.Surface.Presentation;
using System.Globalization;
using Microsoft.Surface.Presentation.Controls;
using System.Reflection;
using FingersDance.ViewModels;

namespace FingersDance.Control.UserPanel
{
	public partial class UserControlUserPanel
	{
        #region Variables

        //public ContactEventHandler ContactDown;
        public event EventHandler OnSuccessAnnotation;  //Event to display ColorAnnotation from different Users   
        public event EventHandler OnTagVisualisation; //Event to Mute all Players
        public int id = 0;
        public uint idcolor = 0;    //The color of the Pivot Button
        private Cutting cut;

        //variables for TagSound Control
        double baseOrientation = 0;
        double deltaOrientation = 0;
        double lastdeltaOrientation = 0;
        int lastSoundlevel = 0;
        bool rise = true; //rise is true if the curse of the volume is positive
        #endregion

        #region Properties
        public Cutting Cutting
        {
            get { return cut; }
            set { cut = value; }
        }
        #endregion

        #region Constructors
        public UserControlUserPanel()
		{
			this.InitializeComponent();

			// Insert code required on object creation below this point.
		}

        public UserControlUserPanel(int idPar, Color col, Cutting cutPar, String path, String AnnotationOrSearchMode)
        {
            this.InitializeComponent();
            id = idPar;
            cut = cutPar;
            // We make the syncsrc load the good video and cutting 
            this.UserControlSyncSource.Load(path, col, cut);
            UserControlSyncSource.OnSuccessAnnotation += new EventHandler(UserControlSyncSource_OnSuccessAnnotation);
            // We make the menu load the good xml
            UCMenu.MenuXmlFile = (AnnotationOrSearchMode == "Search") ? "menu_search.xml" : "menu.xml";
            //SAR -Initialize Tag Values
            InitializeDefinitions();
        }
        #endregion

        #region Tag Management

        private void InitializeDefinitions()
        {
            for (byte k = 1; k <= 5; k++)
            {
                ByteTagVisualizationDefinition tagDef = new ByteTagVisualizationDefinition();
                // The tag value that this definition will respond to. 
                tagDef.Value = k;
                // The .xaml file for the UI. 
                tagDef.Source = new Uri("FingersDance.Control.UserPanel;Component/TagVisuSoundControl.xaml", UriKind.Relative);

                // The maximum number for this tag value. tagDef.MaxCount = 2; 
                // The visualization stays for 2 seconds after the tag is lifted. 
                tagDef.LostTagTimeout = 2000.0;
                // The orientation offset (default). 
                tagDef.OrientationOffsetFromTag = 0.0;
                // The physical offset (horizontal inches, vertical inches). 
                tagDef.PhysicalCenterOffsetFromTag = new Vector(0, 0);
                // The tag removal behavior (default). 
                tagDef.TagRemovedBehavior = TagRemovedBehavior.Fade;
                // Orient UI to tag? (default). 
                tagDef.UsesTagOrientation = true;
                // Add the definition to the collection. 
                this.tagVisualizer.Definitions.Add(tagDef);
            }
        }

        //SAR - Event Rised when Tag Control is moved or rotated
        private void tagVisualizer_VisualizationMoved(object sender, TagVisualizerEventArgs e)
        {
            /*TagVisuSoundControl tagsoundcontrol = (TagVisuSoundControl)e.TagVisualization;
            BindingExpression be = tagsoundcontrol.volumeModel.GetBindingExpression(Label.ContentProperty);
            be.UpdateSource();*/

            TagVisuSoundControl tagsoundcontrol = (TagVisuSoundControl)e.TagVisualization;

            deltaOrientation = (tagsoundcontrol.Orientation - baseOrientation) % 360;
            if (deltaOrientation < 0)
                deltaOrientation = 360 + deltaOrientation;
            int niveau = (int)(deltaOrientation / 36);

            //if (((niveau == 9) || (niveau == 8) || (niveau == 7)) && lastSoundlevel == 0)
            if (((niveau == 9) || (niveau == 8)) && lastSoundlevel == 0)
                rise = false;
            //else if (((niveau == 1) || (niveau == 2) || (niveau == 3)) && lastSoundlevel == 0)
            else if (((niveau == 1) || (niveau == 2)) && lastSoundlevel == 0)
                rise = true;
            
            if (!rise)
            {
                niveau = (niveau - 10) % 10;
            }
            //--Elipse visibility
            int elipseNB = tagsoundcontrol.TagVisuSoundLevelUpdate(niveau);
            //Set the Sound of the Player.
            if(elipseNB != -1)
            {
                UserControlSyncSource.setUserPlayerVolume(elipseNB/10.0);
            }
            lastSoundlevel = niveau;
            tagsoundcontrol.volumeModel.Content = elipseNB;//deltaOrientation.ToString();

        }
        private void OnVisualizationAdded(object sender, TagVisualizerEventArgs e)
        {
            TagVisuSoundControl tagsoundcontrol = (TagVisuSoundControl)e.TagVisualization;

            switch (tagsoundcontrol.VisualizedTag.Byte.Value)
            {
                case 1:
                    try
                    {
                        /*
                        Binding mybinding = new Binding("Orientation");
                        mybinding.Source = tagsoundcontrol;
                        mybinding.UpdateSourceTrigger= UpdateSourceTrigger.PropertyChanged ;
                        tagsoundcontrol.volumeModel.SetBinding(Label.ContentProperty,mybinding);
                        */

                        baseOrientation = tagsoundcontrol.Orientation % 360;
                        deltaOrientation = ((tagsoundcontrol.Orientation % 360) - baseOrientation) % 360;
                        tagsoundcontrol.volumeModel.Content = deltaOrientation;

                        //RiseEvent To Mute all other Players
                        OnTagVisualisation(this, new EventArgs());
                        PlayerMute(false);
                    }
                    catch (Exception ex)
                    {
                    }
                    break;
                case 2: tagsoundcontrol.volumeModel.Content = "Tag Value 2";
                    break;
                case 3: tagsoundcontrol.volumeModel.Content = "Tag Value 3";
                    break;
                case 4: tagsoundcontrol.volumeModel.Content = "Tag Value 4";
                    break;
                case 5: tagsoundcontrol.volumeModel.Content = "Tag Value 5";
                    break;
                default: tagsoundcontrol.volumeModel.Content = "UNKNOWN MODEL";
                    break;
            }
        }

        #endregion

        public void PlayerPause()
        {
            UserControlSyncSource.PlayerPause();
        }
        public void PlayerMute(bool b)
        {
            UserControlSyncSource.setUserPlayerMute(b);
        }

        private void UserControlSyncSource_OnSuccessAnnotation(object sender, EventArgs e)
        {
            OnSuccessAnnotation(this, new EventArgs());
        }  
    }
}