﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using System.Windows.Controls.Primitives;

using FingersDance.Control.TimeLine;


namespace FingersDance.Actions
{
    public class ActionSearchAnnotation : FingersDance.Actions.ActionBase
    {
        UserControlTimeLine myTimeline;
        String GestureId;

        public ActionSearchAnnotation()
        {
            
        }

        public ActionSearchAnnotation(Object[] param)
        {
            // The context param[0] is the userPanel, so we have to get the timeline's instance.
            UserControl userPanel = (UserControl)param[0];
            // Its content...
            Grid o = (Grid)userPanel.Content;
            // and the UserControlSyncSource within the grid...
            UserControl syncSrc = (UserControl)((Grid)o.Children[1]).Children[0];
            // and finally the timeline
            myTimeline = (UserControlTimeLine)((Grid)((Grid)syncSrc.Content).Children[0]).Children[0];

            GestureId = (String)param[1];
        }

        public void Execute()
        {
            Console.WriteLine("ActionSearchAnnotation Execute " + GestureId);
            if (myTimeline != null)
                myTimeline.sendNewGesture(GestureId);
        }
    }
}
