﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace FingersDance.Control.SessionInput
{

    /// <summary>
    /// Interaction logic for UserControlAnnotationOrSearch.xaml
    /// </summary>
    public partial class UserControlAnnotationOrSearch : UserControl
    {
        public event EventHandler<AnnotationOrSearchEventArg> ModeChosen;

        public UserControlAnnotationOrSearch()
        {
            InitializeComponent();
        }

        private void annotBtn_Click(object sender, RoutedEventArgs e)
        {
            ModeChosen(this, new AnnotationOrSearchEventArg("Annotation"));
        }

        private void annotBtn_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            ModeChosen(this, new AnnotationOrSearchEventArg("Annotation"));
        }

        private void searchBtn_Click(object sender, RoutedEventArgs e)
        {
            ModeChosen(this, new AnnotationOrSearchEventArg("Search"));
        }

        private void searchBtn_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            ModeChosen(this, new AnnotationOrSearchEventArg("Search"));
        }
    }


    /// <summary>
    /// AnnotationOrSearchEventArg
    /// </summary>
    public class AnnotationOrSearchEventArg : EventArgs
    {
        public String ChosenMode
        {
            get;
            set;
        }

        public AnnotationOrSearchEventArg(String chosenMode)
        {

            ChosenMode = chosenMode;

        }
    }
}
