﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using System.ComponentModel;

namespace Control.Player.Test
{
	public partial class UserControlPlayer
	{

        private bool play;

		public UserControlPlayer()
		{
			this.InitializeComponent();
             
            initPlayer();
		}

        void initPlayer()
        { 
            //init player
            play = false;
            MediaElementVideo.Source = new Uri("Resources\\Lake.wmv", UriKind.Relative);
            MediaElementVideo.LoadedBehavior = MediaState.Manual;
        }

        private void ButtonPlayPause_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (!play)//Play
            {
                play = true;
                try
                {
                    MediaElementVideo.Play();
                }
                catch (Exception ex) { }
            }
            else//Pause
            {
                play = false;
                try
                {
                    MediaElementVideo.Pause();
                }
                catch (Exception exx ) { }
            }

        }

        private void ButtonPlayPause_Click(object sender, RoutedEventArgs e)
        {
            if (!play)//Play
            {
                play = true;
                try
                {
                    MediaElementVideo.Play();
                }
                catch (Exception ex ) { }
                
            }
            else//Pause
            {
                play = false;
                try
                {
                    MediaElementVideo.Pause();
                }
                catch (Exception exx ) { }
                //ButtonPlayPause.Background = FindResource("[Skin_1]_Play_button_xaml") as Brush;
            }
        }

        private void ButtonFastForward_Click(object sender, RoutedEventArgs e)
        {
            if(MediaElementVideo.SpeedRatio <= 3)
                MediaElementVideo.SpeedRatio += 1;
        }

        private void ButtonFastForward_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (MediaElementVideo.SpeedRatio <= 3)
                MediaElementVideo.SpeedRatio += 1;
        }

       private void ButtonRewind_Click(object sender, RoutedEventArgs e)
        {
            //TimeSpan ts = new TimeSpan(0, 0, 0, 0);
            if (MediaElementVideo.SpeedRatio > 1)
            {
                MediaElementVideo.SpeedRatio -= 1;
            }
            else
            {
                MediaElementVideo.Position = MediaElementVideo.Position.Add(new TimeSpan(0, 0, 0, -5));
            }
        }

        private void ButtonRewind_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {

            //TimeSpan ts = new TimeSpan(0, 0, 0,0);
            if (MediaElementVideo.SpeedRatio > 1)
            {
                MediaElementVideo.SpeedRatio -= 1;
            }
            else
            {
                MediaElementVideo.Position = MediaElementVideo.Position.Add(new TimeSpan(0, 0, 0, -5));
            }
        }
	}
}