﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FingersDance.Actions;

namespace FingersDance.ActionFactory
{
    public class ActionGenerator
    {
        private Dictionary<String, Type> actionDict = new Dictionary<string, Type>();

        public ActionGenerator()
        {
            actionDict.Add("ActionPlayMedia", typeof(FingersDance.Actions.ActionPlayMedia));
            actionDict.Add("ActionShowMessage", typeof(FingersDance.Actions.ActionShowMessage));
            actionDict.Add("ActionOpenMedia", typeof(FingersDance.Actions.ActionOpenMedia));
            actionDict.Add("ActionStopMedia", typeof(FingersDance.Actions.ActionStopMedia));

            actionDict.Add("ActionStartOrEndAnnotation", typeof(FingersDance.Actions.ActionStartOrEndAnnotation));
            actionDict.Add("ActionAddAnnotation", typeof(FingersDance.Actions.ActionAddAnnotation));
        }

        public ActionBase GetAction(String T, Object Args)
        {

            try
            {
                ActionBase ab = (ActionBase)Activator.CreateInstance(actionDict[T], Args);
                return ab;
            }
            catch (Exception ex) { }
            return null;
        }
    }
}
