﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using FingersDance.Data;

namespace FingersDance.ViewModels
{
    public class CuttingViewModel : ViewModelBase
    {
        private Cutting cut;

        private List<AnnotationViewModel> _annotList = new List<AnnotationViewModel>();

        public CuttingViewModel(Cutting c, float annotWidth, Double scaleX)
        {

            cut = c;
            this._annotList = new List<AnnotationViewModel>();
            int i = 0;
            foreach (Annotation annot in c.AnnotList)
            {
                this._annotList.Add(new AnnotationViewModel(annot, annot.TcBegin - (i * annotWidth), 1 / scaleX));
                i++;
            }

        }

        public CuttingViewModel(Cutting c, float annotWidth) {

            cut = c;
            this._annotList = new List<AnnotationViewModel>();
            int i = 0;
            foreach (Annotation annot in c.AnnotList)
            {
                this._annotList.Add(new AnnotationViewModel(annot, annot.TcBegin - (i * annotWidth)));
                i++;
            }

        }

        public Cutting Cutting
        {
            get { return cut; }
            set
            {
                cut = value;
                base.OnPropertyChanged("Cutting");
            }
        }

        public String Id
        {
            get { return cut.Id; }
            set
            {
                if (value == cut.Id || String.IsNullOrEmpty(value))
                    return;
                cut.Id = value;
                base.OnPropertyChanged("Id");
            }
        }
        public String Title  
        {
            get { return cut.Title; }
            set
            {
                if (value == cut.Title || String.IsNullOrEmpty(value))
                    return;
                cut.Title = value;
                base.OnPropertyChanged("Title");
            }
        }
        public List<AnnotationViewModel> AnnotList
        {
            get { return _annotList; }
            set
            {
                _annotList = value;
                base.OnPropertyChanged("AnnotList");
            }
        }

        public void setListFromAnnotations(List<Annotation> annotList, float annotWidth, Double scaleX)
        {

            this._annotList = new List<AnnotationViewModel>();
            int i = 0;
            foreach (Annotation annot in annotList)
            {
                this._annotList.Add(new AnnotationViewModel(annot, annot.TcBegin - (i * annotWidth), 1/scaleX));
                i++;
            }

        }
    }
}
