﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace FingersDance.Data
{
    public class AnnotationAddedEventArg : EventArgs
    {
        private float _tcBegin;
        private float _dur;  
        private String _gestureType;

        public float TcBegin
        {
            get { return this._tcBegin; }
        }
        public float Dur
        {  
            get { return this._dur; }
        }  
        public String GestureType
        {  
            get { return this._gestureType; }
        }

        public AnnotationAddedEventArg(float tcBegin, float dur, String gestureType) {

            this._tcBegin = tcBegin;
            this._dur = dur;
            this._gestureType = gestureType;
        
        }

    }

    public class Annotation
    {
        private float _tcBegin;
        private float _dur;
        private string _gestureType;

        //public event EventHandler<AnnotationAddedEventArg> AnnotationAdded;

        public Annotation(float tcBeginPar, float durPar, string gesturePar)
        {
            this._tcBegin = tcBeginPar;
            this._dur = durPar;
            this._gestureType = gesturePar;

            //AnnotationAdded(this, new AnnotationAddedEventArg(_tcBegin, _dur, _gestureType));

        }

        public float TcBegin
        {
            get { return _tcBegin; }
            set
            {
                if (value == _tcBegin || float.IsNaN(value))
                    return;
                _tcBegin = value;
            }
        }
        public float Dur
        {
            get { return _dur; }
            set
            {
                if (value == _dur || float.IsNaN(value))
                    return;
                _dur = value;
            }
        }
        public String GestureType
        {
            get { return _gestureType; }
            set
            {
                if (value == _gestureType || String.IsNullOrEmpty(value))
                    return;
                _gestureType = value;
            }
        }
        
    }

}
