﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using FingersDance.Control.TimeLine;

namespace FingersDance.Control.SyncSource
{
	public partial class UserControlSyncSource
	{
		public UserControlSyncSource()
		{
			this.InitializeComponent();

			// Insert code required on object creation below this point.
		}

        public void Load(string path)
        {
            this.UserControlPlayer.initPlayer(path);
        }

        #region player
        private void UserControlPlayer_PlayerOpened(object sender, EventArgs e)
        {
            //Initialisation du Timer
            UCTimeLine.initTimer();
            //Initialisation du slider
            UCTimeLine.initslider(UserControlPlayer.TotalMilliseconds);
            //Demarrage du Timer
            UCTimeLine.timerStart();

        }
        #endregion

        #region TimeLine


        private void UserControlTimeLine_DragStarted(object sender, EventArgs e)
        {
            UserControlPlayer.playerPause();
        }


        private void UserControlTimeLine_DragCompleted(object sender, EventArgs e)
        {
        }
        #endregion


        #region SynSource pour chaque X milliseconds
        private void UserControlTimeLine_TimerTick(object sender, EventArgs e)
        {
            if (!UCTimeLine.IsDragging)
            {
                UCTimeLine.Slider.Value = UserControlPlayer.Player.Position.TotalMilliseconds;
            }
            if (UCTimeLine.FinishedDragging)
            {
                int SliderValue = (int)UCTimeLine.Slider.Value;
                TimeSpan ts = new TimeSpan(0, 0, 0, 0, SliderValue);

                UserControlPlayer.Player.Position = ts;
                UserControlPlayer.playerPlay();

                UCTimeLine.IsDragging = false;
                UCTimeLine.FinishedDragging = false;
            }
        }
        #endregion

        public UserControlTimeLine userControlTimeLine
        {
            get { return this.UCTimeLine; }
        }
    }
}