﻿using System;
using System.IO;
using System.Net;
using System.Collections.Generic;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using FingersDance.Control.ListVideo;
using FingersDance.Control.SessionInput;
using FingersDance.ViewModels;
using FingersDance.Data;

namespace FingersDance.Control.Screen
{
	public partial class UserControlScreen
	{
        public String contexteGrid;
        public int id = 0;
        public event EventHandler UC_Screen_NewSession;
        public MainViewModel MainViewModel;
        public ProjectViewModel Project = new ProjectViewModel();
        List<Session> sessions = new List<Session>();
        User User = new User();

        public UserControlScreen(int id, MainViewModel mvmodel)
        {
            try
            {
                this.InitializeComponent();
                this.id = id;
                MainViewModel = mvmodel;
                if (MainViewModel.Session.VideoPath.Equals(""))
                {
                    //1-Creation de la ListVideo
                    UserControlListVideo ListVideo = new UserControlListVideo();
                    ListVideo.Name = "ListVideo1";
                    //2-Ajout de la ListVideo au ControlScreen
                    this.AddToGrid(ListVideo);
                    //3-Creation des Events pour chaque item de la video
                    ListVideo.EH_ItemVideo1_ContactDown += new System.EventHandler(this.ListVideo_EH_ItemVideo_ContactDown);
                }
                else
                    OpenProject();
            }
            catch (Exception)
            {
                Project = null;
                if (UC_Screen_NewSession != null)
                    UC_Screen_NewSession(this, new EventArgs());
            }
        }

        //Rajout un UIElement vers la grid du screen.
        public void AddToGrid(UIElement uie)
        {
            if (uie != null)
            {
                try { LayoutRoot.Children.Add(uie); }
                catch(Exception){}
            }          
        }

        private void ListVideo_EH_ItemVideo_ContactDown(object sender, EventArgs e)
        {
            try
            {
                //1 rensegner la video choisie au screen
                MainViewModel.CreateSession(((UserControlListVideo)sender).VideoName, ((UserControlListVideo)sender).path);
                //2-Supression du UC List Video
                LayoutRoot.Children.Remove((UserControlListVideo)sender);
                OpenSession();
            }
            catch (Exception ex)
            {
                Project = null;
                if (UC_Screen_NewSession != null)
                    UC_Screen_NewSession(this, new EventArgs());
            }
        }

        private void OpenSession()
        {
            try
            {
                sessions = LoadSessions(MainViewModel.Session.VideoPath);
                UserControlListSession listSession = new UserControlListSession(sessions);
                listSession.Name = "ListSession";
                LayoutRoot.Children.Add(listSession);
                listSession.EH_List_ContactDown += new EventHandler(listSession_EH_List_ContactDown);
            }
            catch (Exception)
            {
                Project = null;
                if (UC_Screen_NewSession != null)
                    UC_Screen_NewSession(this, new EventArgs());
            }
        }

        private List<Session> LoadSessions(string name)
        {
            try
            {
                return new List<Session>();
            }
            catch (Exception) 
            {
                return new List<Session>();
            }
        }

        void listSession_EH_List_ContactDown(object sender, EventArgs e)
        {
            try
            {
                LayoutRoot.Children.Remove((UserControlListSession)sender);
                if (((UserControlListSession)sender).SelectedItem.Equals("New Session"))
                {
                    UserControlSessionInput SessionInput = new UserControlSessionInput();
                    SessionInput.Name = "SessionInput";
                    LayoutRoot.Children.Add(SessionInput);
                    SessionInput.EH_SurfaceButtonSubmit_ContactDown += new System.EventHandler(this.SessionInput_EH_SurfaceButtonSubmit_ContactDown);
                }
                else
                {
                    foreach (Session elt in sessions)
                    {
                        if (elt.Name.Equals(((UserControlListSession)sender).SelectedItem))
                        {
                            MainViewModel.Session.Projects = elt.Projects;
                            OpenProject();
                            return;
                        }
                    }
                }
            }
            catch (Exception)
            {
                Project = null;
                if (UC_Screen_NewSession != null)
                    UC_Screen_NewSession(this, new EventArgs());
            }
        }

        private void SessionInput_EH_SurfaceButtonSubmit_ContactDown(object sender, EventArgs e)
        {
            try
            {
                MainViewModel.Session.Alias = ((UserControlSessionInput)sender).Alias;
                MainViewModel.Session.Email = ((UserControlSessionInput)sender).Email;
                MainViewModel.Session.Description = ((UserControlSessionInput)sender).Description;
                MainViewModel.Session.Name = ((UserControlSessionInput)sender).Name;
                
                //2-Suppression UCSession Input
                LayoutRoot.Children.Remove((UserControlSessionInput)sender);
                OpenProject();
            }
            catch (Exception ex) 
            {
                Project = null;
                if (UC_Screen_NewSession != null)
                    UC_Screen_NewSession(this, new EventArgs());
            }
        }

        private void OpenProject()
        {
            try
            {
                UserControlListProject listProjects = new UserControlListProject(MainViewModel.Session.Projects);
                listProjects.Name = "ListProjects";
                LayoutRoot.Children.Add(listProjects);
                listProjects.EH_Item_ContactDown += new EventHandler(listProjects_EH_Item_ContactDown);
            }
            catch (Exception) 
            {
                Project = null;
                if (UC_Screen_NewSession != null)
                    UC_Screen_NewSession(this, new EventArgs());
            }
        }

        void listProjects_EH_Item_ContactDown(object sender, EventArgs e)
        {
            try
            {
                LayoutRoot.Children.Remove((UserControlListProject)sender);
                if (((UserControlListProject)sender).SelectedItem.Equals("New Project"))
                {
                    UserControlNewProject newProject = new UserControlNewProject(User);
                    newProject.Name = "newProject";
                    LayoutRoot.Children.Add(newProject);
                    newProject.EH_NewProject_ContactDown += new EventHandler(newProject_EH_NewProject_ContactDown);
                } 
                else
                {
                    foreach(KeyValuePair<string, Project> elt in MainViewModel.Session.Projects)
                        if (elt.Key.Equals(((UserControlListProject)sender).SelectedItem))
                        {
                            Project = new ProjectViewModel(elt.Value);
                            if (UC_Screen_NewSession != null)
                                UC_Screen_NewSession(this, new EventArgs());
                            return;
                        }
                }
            }
            catch (Exception)
            {
                Project = null;
                if (UC_Screen_NewSession != null)
                    UC_Screen_NewSession(this, new EventArgs());
            }
        }

        void newProject_EH_NewProject_ContactDown(object sender, EventArgs e)
        {
            try
            {
                LayoutRoot.Children.Remove((UserControlNewProject)sender);
                Project = new ProjectViewModel(((UserControlNewProject)sender).Project);
                MainViewModel.Session.Projects.Add(Project.Name, Project.Project);
                if (UC_Screen_NewSession != null)
                    UC_Screen_NewSession(this, new EventArgs());
            }
            catch (Exception) 
            {
                Project = null;
                if (UC_Screen_NewSession != null)
                    UC_Screen_NewSession(this, new EventArgs());
            }
        }
	}
}