﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using FingersDance.Data;

namespace FingersDance.Control.SessionInput
{
    /// <summary>
    /// Interaction logic for UserControlNewCuttingForm.xaml
    /// </summary>
    public partial class UserControlNewCuttingForm : UserControl
    {
        public event EventHandler EH_NewCuttingForm_ContactDown;
        public Cutting Cutting = new Cutting();
        User _User = new User();

        public UserControlNewCuttingForm(User u)
        {
            InitializeComponent();
            ST_Date.Text = DateTime.Now.Day.ToString() + "/" + DateTime.Now.Month.ToString() + "/" + DateTime.Now.Year.ToString();
            _User = u;


        }

        #region Actions

        private void SurfaceButtonSubmit_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            Cutting = new Cutting("c_" + System.Guid.NewGuid(), ST_CuttingName.Text.Trim(), new List<Annotation>());   
            if (EH_NewCuttingForm_ContactDown != null)
                EH_NewCuttingForm_ContactDown(this, new EventArgs());
        }

        private void SurfaceButtonSubmit_Click(object sender, RoutedEventArgs e)
        {
            Cutting = new Cutting("c _" + System.Guid.NewGuid(), ST_CuttingName.Text.Trim(), new List<Annotation>());
            if (EH_NewCuttingForm_ContactDown != null)
                EH_NewCuttingForm_ContactDown(this, new EventArgs());   
        }

        #endregion
    }
} 
