﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;
using System.Windows.Controls.Primitives;
using Microsoft.Surface.Presentation.Controls;
using System.Windows.Threading;

using FingersDance.Data;
using FingersDance.ViewModels;

namespace FingersDance.Control.TimeLine
{
	public partial class UserControlTimeLine
    {

        #region Variables
        private DispatcherTimer timer;
        private bool isDragging = false;
        private bool finishedDragging = false;
        #endregion

        public event EventHandler DragStarted;
        public event EventHandler DragCompleted;
        public event EventHandler TimerTick;

        #region Properties

        public SurfaceSlider Slider
        {
            get
            {
                return slider;
            }
            set
            {
                slider = value;
            }
        }
        
        public bool IsDragging
        {
            get
            {
                return isDragging;
            }
            set
            {
                isDragging = value;
            }
        }

        public bool FinishedDragging
        {
            get
            {
                return finishedDragging;
            }
            set
            {
                finishedDragging = value;
            }
        }

        public DispatcherTimer Timer
        {
            get
            {
                return timer;
            }
            set
            {
                timer = value;
            }
        }
        #endregion
        


        
		public UserControlTimeLine()
		{
			this.InitializeComponent();

			// Insert code required on object creation below this point.
            
		}

        public void initslider(double totalmilliseconds)
        {
            slider.Maximum = totalmilliseconds;


            // TEMP FOR DATA BINDING
            List<Annotation> annotList = new List<Annotation>();
            annotList.Add(new Annotation(0, 10, "Axe Cam 1"));
            annotList.Add(new Annotation(10, 20, "Mvt Cam 2"));
            annotList.Add(new Annotation(30, 40, "Saut 3"));
            Cutting cut = new Cutting("titre de cutting", annotList);
            CuttingViewModel cutvm = new CuttingViewModel(cut);
            tv.DataContext = cut;


        }

        #region Timer
        public void initTimer()
        {
            timer = new DispatcherTimer();
            timer.Interval = new TimeSpan(0, 0, 0, 0, 100);
            timer.Tick += new EventHandler(timer_Tick);
        }

        public void timerStart()
        {
            if (timer != null)
                timer.Start();
        }
        void timer_Tick(object sender, EventArgs e)
        {
            OnTimerTick();
            if (!isDragging)
            {
                //slider.Value = media.Position.TotalMilliseconds;
            }
            if (finishedDragging)
            {
                //int SliderValue = (int)slider.Value;
                //TimeSpan ts = new TimeSpan(0, 0, 0, 0, SliderValue);
               // media.Position = ts;
               // media.Play();
               // isDragging = false;
                //finishedDragging = false;
            }
        }
        protected virtual void OnTimerTick()
        {
            if (TimerTick != null)
                TimerTick(this, new EventArgs());
        }

        #endregion

        private void sliderPosition_DragStarted(
            object sender, DragStartedEventArgs e)
        {
            isDragging = true;
            OnDragStarted();
           // media.Pause();
        }
        protected virtual void OnDragStarted()
        {
            if (DragStarted != null)
                DragStarted(this, new EventArgs());
        }

        private void sliderPosition_DragCompleted(
            object sender, DragCompletedEventArgs e)
        {
            finishedDragging = true;
            OnDragCompleted();
        }
        protected virtual void OnDragCompleted()
        {
            if (DragCompleted != null)
                DragCompleted(this, new EventArgs());
        }

	}
}