﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using FingersDance.Data;

namespace FingersDance.ViewModels
{
    public class CuttingViewModel : ViewModelBase
    {
        private string _title;
        private List<AnnotationViewModel> _annotList = new List<AnnotationViewModel>();

        public CuttingViewModel(Cutting c, float annotWidth) {

            this._title = c.Title;
            this._annotList = new List<AnnotationViewModel>();
            int i = 0;
            foreach (Annotation annot in c.AnnotList)
            {
                this._annotList.Add(new AnnotationViewModel(annot, annot.TcBegin - (i * annotWidth)));
                i++;
            }

        }

        public String Title
        {
            get { return _title; }
            set
            {
                if (value == _title || String.IsNullOrEmpty(value))
                    return;
                _title = value;
                base.OnPropertyChanged("Title");
            }
        }
        public List<AnnotationViewModel> AnnotList
        {
            get { return _annotList; }
            set
            {
                _annotList = value;
                base.OnPropertyChanged("AnnotList");
            }
        }

        public void setListFromAnnotations(List<Annotation> annotList, float annotWidth)
        {

            this._annotList = new List<AnnotationViewModel>();
            int i = 0;
            foreach (Annotation annot in annotList)
            {
                this._annotList.Add(new AnnotationViewModel(annot, annot.TcBegin - (i * annotWidth)));
                i++;
            }

        }
    }
}
