﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Microsoft.Surface.Presentation;

namespace FingersDance.Views
{
    /// <summary>
    /// Interaction logic for TimelineAnnotationView.xaml
    /// </summary>
    public partial class TimelineAnnotationView : UserControl
    {

        public static readonly DependencyProperty ScaleXProperty = DependencyProperty.Register("ScaleX", typeof(Double), typeof(TimelineAnnotationView));

        public TimelineAnnotationView()
        {
            InitializeComponent();
        }

        public Double ScaleX
        {
            get { return (Double)GetValue(ScaleXProperty); }
            set { SetValue(ScaleXProperty, value); }
        }
    }

    public class ThicknessSingleValueConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            ThicknessConverter myThicknessConverter = new ThicknessConverter();
            Thickness th1 = (Thickness)myThicknessConverter.ConvertFrom(value);
            th1.Top = 0;
            th1.Bottom = th1.Right = 0;
            return th1;
        }
        public object ConvertBack(object value, Type targetTypes, object parameter, System.Globalization.CultureInfo culture)
        {
            Thickness thickness = (Thickness)value;
            return thickness.Left;
        }
    }

    public class VisibilityConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            Visibility v = ((float)value > 0) ? Visibility.Visible : Visibility.Hidden;
            return v;
        }
        public object ConvertBack(object value, Type targetTypes, object parameter, System.Globalization.CultureInfo culture)
        {
            return 1.0;
        }
    }
    
    public class ColorConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            //UInt32 argb = (UInt32)value;
            //Color c = Color.FromArgb((Byte)((argb >> 24) & 0xFF), (Byte)((argb >> 16) & 0xFF), (Byte)((argb >> 8) & 0xFF), (Byte)(argb & 0xFF));
            SolidColorBrush scb = new SolidColorBrush((Color)value);
            return scb;
        }
        public object ConvertBack(object value, Type targetTypes, object parameter, System.Globalization.CultureInfo culture)
        {
            return 1.0;
        }
    }
}
