﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections.ObjectModel;

using FingersDance.Data;

namespace FingersDance.ViewModels
{
    public class MainViewModel
    {
        #region Attributes

        public Dictionary<String, UserViewModel> Users = new Dictionary<string,UserViewModel>();
        public SessionViewModel Session = new SessionViewModel();

        #endregion
        
        #region Methods

        public Project CreateProject(User u)
        {
            if (Users.ContainsKey(u.Email))
            {
                if (Session.Projects.ContainsKey(u.Email))
                    return Session.Projects[u.Email];
                else
                {
                    Project p = new Project(u, new Cutting());
                    Session.Projects.Add(u.Email, p);
                    return p;
                }
            }
            else
            {
                AddUser(u);
                Project p = new Project(u, new Cutting());
                Session.Projects.Add(u.Email, p);
                return p;
            }
        }

        public void CreateSession(string name, string path)
        {
            Session = new SessionViewModel(new Session(name, path));
        }

        public void CloseSession()
        {
            Session = null;
            Session = new SessionViewModel();
        }

        private void AddUser(User u)
        {
            UserViewModel uvm = new UserViewModel(u);
            Users.Add(u.Email, uvm);
        }

        #endregion
    }
}
