﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Input;
using System.Windows;

namespace GestureControl
{
    /// <summary>
    /// Gesture event who return a object with a Gesture String value
    /// </summary>
    public class GestureRoutedEventArgs : RoutedEventArgs
    {
        public Gesture Gesture { get; private set; }

        public GestureRoutedEventArgs() : base() { }
        public GestureRoutedEventArgs(Gesture gesture) : base() { this.Gesture = gesture; }
        public GestureRoutedEventArgs(RoutedEvent routedEvent) : base(routedEvent) { }
        public GestureRoutedEventArgs(RoutedEvent routedEvent, Gesture gesture) : base(routedEvent) { this.Gesture = gesture; }
        public GestureRoutedEventArgs(RoutedEvent routedEvent, Object source) : base(routedEvent, source) { }
        public GestureRoutedEventArgs(RoutedEvent routedEvent, Object source, Gesture gesture) : base(routedEvent, source) { this.Gesture = gesture; }
    }
}
