﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FingersDance.Data;

namespace FingersDance.ViewModels
{
    public class ProjectViewModel : ViewModelBase
    {
        private Project project = new Project();

        private Dictionary<String, Cutting> _cuttingsDict = new Dictionary<string,Cutting>();

        #region Constructor

        public ProjectViewModel() { }

        public ProjectViewModel(Project p)
        {
            project = p;
        }

        #endregion

        #region Properties

        public Project Project
        {
            get { return project; }
            set { project = value; }
        }

        public string Date
        {
            get { return project.Date; }
            set { project.Date = value; }
        }

        public string Name
        {
            get { return project.Name; }
            set { project.Name = value; }
        }

        public string Description
        {
            get { return project.Description; }
            set { project.Description = value; }
        }

        public String VideoPath
        {
            get { return project.VideoPath; }
            set { project.VideoPath = value; }
        }

        //public User User
        //{
        //    get { return project.User; }
        //    set { project.User = value; }
        //}

        public List<Cutting> Cuttings
        {
            get { return project.Cuttings; }
            set { project.Cuttings = value; }
        }

        public Dictionary<String, Cutting> CuttingsDict
        {
            get { return _cuttingsDict;  }
            set { _cuttingsDict = value; }
        }

        #endregion
    }
}
