﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace FingersDance.Data
{
    class AnnotationAddedEventArg : EventArgs
    {
        private float _tcBegin;
        private float _dur;  
        private String _gestureType;

        public float tcBegin
        {
            get { return this._tcBegin; }
        }
        public float dur
        {  
            get { return this._dur; }
        }  
        public String gestureType
        {  
            get { return this._gestureType; }
        }

        public AnnotationAddedEventArg(float tcBegin, float dur, String gestureType) {

            this._tcBegin = tcBegin;
            this._dur = dur;
            this._gestureType = gestureType;
        
        }

    }

    class Annotation
    {
        private float tcBegin;
        private float dur;
        private string gestureType;

        public event EventHandler<AnnotationAddedEventArg> AnnotationAdded;

        public Annotation(float tcBeginPar, float durPar, string gesturePar)
        {
            this.tcBegin = tcBeginPar;
            this.dur = durPar;
            this.gestureType = gesturePar;

            AnnotationAdded(this, new AnnotationAddedEventArg(tcBegin, dur, gestureType));

        }
        
    }

}
