﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace FingersDance.ViewModel
{
    class CuttingViewModel : ViewModelBase
    {
        private string _title;
        private List<AnnotationViewModel> _annotList = new List<AnnotationViewModel>();
        
        public String Title
        {
            get { return _title; }
            set
            {
                if (value == _title || String.IsNullOrEmpty(value))
                    return;
                _title = value;
                base.OnPropertyChanged("Title");
            }
        }
        public List<AnnotationViewModel> AnnotList
        {
            get { return _annotList; }
            set
            {
                _annotList = value;
                base.OnPropertyChanged("AnnotList");
            }
        }
    }
}
