﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace FingersDance.ViewModel
{
    class AnnotationViewModel : ViewModelBase
    {
        private float _tcBegin;
        private float _dur;
        private String _gestureType;

        public float tcBegin
        {
            get { return _tcBegin; }
            set {
                if (value == _tcBegin || float.IsNaN(value))
                    return;
                _tcBegin = value;
                base.OnPropertyChanged("TcBegin");
            }
        }
        public float dur
        {
            get { return _dur; }
            set
            {
                if (value == _dur || float.IsNaN(value))
                    return;
                _dur = value;
                base.OnPropertyChanged("Dur");
            }
        }
        public String gestureType
        {
            get { return _gestureType; }
            set
            {
                if (value == _gestureType || String.IsNullOrEmpty(value))
                    return;
                _gestureType = value;
                base.OnPropertyChanged("GestureType");
            }
        }

    }
}
