﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections.ObjectModel;

using FingersDance.Data;

namespace FingersDance.ViewModels
{
    public class MainViewModel
    {
        #region Attributes

        public Dictionary<String, UserViewModel> Users = new Dictionary<string,UserViewModel>();
        public ProjectViewModel Project = new ProjectViewModel();

        #endregion
        
        #region Methods

        public void CreateProject(string videoName, string videoPath)
        {
            Project = new ProjectViewModel(new Project(videoName, videoPath));
        }

        public void CloseProject()
        {
            Project = null;
            Project = new ProjectViewModel();
        }

        private void AddUser(User u)
        {
            UserViewModel uvm = new UserViewModel(u);
            Users.Add(u.Email, uvm);
        }

        #endregion
    }
}
