﻿using System;
using System.IO;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Navigation;

namespace FingersDance.Control.Close
{
    public class ConfirmEventArgs : EventArgs
    {
        public Boolean Confirmed;
        public int PanelNumber = 0;

        public ConfirmEventArgs(Boolean b)
        {
            Confirmed = b;
        }
        public ConfirmEventArgs(Boolean b, int panelNum)
        {
            Confirmed = b;
            PanelNumber = panelNum;
        }
    }

	public partial class UserControlClose
	{
        public event EventHandler<ConfirmEventArgs> ConfirmYesOrNo; 
        public bool close;
        public int Id = 0;

        public static readonly DependencyProperty QuestionProperty = DependencyProperty.Register("Question", typeof(String), typeof(UserControlClose));

		public UserControlClose()
		{
			this.InitializeComponent();

			// Insert code required on object creation below this point.
        }


        public UserControlClose(int closeid, String sentence)
        {
            this.InitializeComponent();

            Id = closeid;
            Question = sentence;
        }


        public String Question
        {
            get { return (String)GetValue(QuestionProperty); }
            set { SetValue(QuestionProperty, value); }
        }


        private void SurfaceButtonOK_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (ConfirmYesOrNo != null)
            {
                close = true;
                ConfirmYesOrNo(this, new ConfirmEventArgs(true, Id));
            }
        }

        private void SurfaceButtonOK_Click(object sender, RoutedEventArgs e)
        {
            if (ConfirmYesOrNo != null)
            {
                close = true;
                ConfirmYesOrNo(this, new ConfirmEventArgs(true, Id));
            }
        }

        private void SurfaceButtonNO_ContactDown(object sender, Microsoft.Surface.Presentation.ContactEventArgs e)
        {
            if (ConfirmYesOrNo != null)
            {
                close = false;
                ConfirmYesOrNo(this, new ConfirmEventArgs(false, Id));
            }
        }

        private void SurfaceButtonNO_Click(object sender, RoutedEventArgs e)
        {
            if (ConfirmYesOrNo != null)
            {
                close = false;
                ConfirmYesOrNo(this, new ConfirmEventArgs(false, Id));
            }
        }
	}
}