from django.contrib import admin
from django.contrib.auth.models import Group
from guardian.admin import GuardedModelAdmin
from ldt.user.models import LdtUser
from models import GroupProfile

class GroupProfileInline(admin.StackedInline):
    model = GroupProfile

class GroupAdmin(GuardedModelAdmin):
    inlines = [GroupProfileInline, ]

class LdtUserAdmin(admin.ModelAdmin):
    pass


admin.site.unregister(Group)
admin.site.register(Group, GroupAdmin)

admin.site.register(LdtUser, LdtUserAdmin)