#@PydevCodeAnalysisIgnore
# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models
import uuid

class Migration(SchemaMigration):
    
    depends_on = (
        ("core", "0001_initial"),
    )

    def forwards(self, orm):
        
        # Adding model 'Author'
        db.create_table('ldt_utils_author', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('handle', self.gf('django.db.models.fields.CharField')(max_length=255, unique=True, null=True, blank=True)), #this does not match modeldefinition because of mysql limitations
            ('email', self.gf('django.db.models.fields.EmailField')(max_length=75, null=True, blank=True)),
            ('firstname', self.gf('django.db.models.fields.CharField')(max_length=512, null=True, blank=True)),
            ('lastname', self.gf('django.db.models.fields.CharField')(max_length=512, null=True, blank=True)),
        ))
        db.send_create_signal('ldt_utils', ['Author'])

        # Adding model 'Media'
        db.create_table('ldt_utils_media', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('external_id', self.gf('django.db.models.fields.CharField')(max_length=1024, null=True, blank=True)),
            ('external_permalink', self.gf('django.db.models.fields.URLField')(max_length=1024, null=True, blank=True)),
            ('external_publication_url', self.gf('django.db.models.fields.URLField')(max_length=1024, null=True, blank=True)),
            ('external_src_url', self.gf('django.db.models.fields.URLField')(max_length=1024, null=True, blank=True)),
            ('creation_date', self.gf('django.db.models.fields.DateTimeField')(auto_now_add=True, blank=True)),
            ('media_creation_date', self.gf('django.db.models.fields.DateTimeField')(null=True, blank=True)),
            ('update_date', self.gf('django.db.models.fields.DateTimeField')(auto_now=True, blank=True)),
            ('videopath', self.gf('django.db.models.fields.CharField')(max_length=1024, null=True, blank=True)),
            ('duration', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('creator', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['auth.User'], null=True, blank=True)),
            ('description', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('title', self.gf('django.db.models.fields.CharField')(max_length=1024, null=True, blank=True)),
            ('src', self.gf('django.db.models.fields.CharField')(max_length=1024)),
        ))
        db.send_create_signal('ldt_utils', ['Media'])

        # Adding model 'Content'
        db.create_table('ldt_utils_content', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('iri_id', self.gf('django.db.models.fields.CharField')(default=lambda: unicode(uuid.uuid1()), unique=True, max_length=255)), #this does not match modeldefinition because of mysql limitations
            ('iriurl', self.gf('django.db.models.fields.CharField')(max_length=1024)),
            ('creation_date', self.gf('django.db.models.fields.DateTimeField')(auto_now_add=True, blank=True)),
            ('update_date', self.gf('django.db.models.fields.DateTimeField')(auto_now=True, blank=True)),
            ('title', self.gf('django.db.models.fields.CharField')(max_length=1024, null=True, blank=True)),
            ('description', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
            ('duration', self.gf('django.db.models.fields.IntegerField')(null=True, blank=True)),
            ('content_creation_date', self.gf('django.db.models.fields.DateTimeField')(null=True, blank=True)),
            ('tags', self.gf('tagging.fields.TagField')(max_length=2048, null=True)),
            ('media_obj', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['ldt_utils.Media'], null=True, blank=True)),
        ))
        db.send_create_signal('ldt_utils', ['Content'])

        # Adding M2M table for field authors on 'Content'
        db.create_table('ldt_utils_content_authors', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('content', models.ForeignKey(orm['ldt_utils.content'], null=False)),
            ('author', models.ForeignKey(orm['ldt_utils.author'], null=False))
        ))
        db.create_unique('ldt_utils_content_authors', ['content_id', 'author_id'])

        # Adding model 'Project'
        db.create_table('ldt_utils_project', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('owner', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['core.Owner'], null=True, blank=True)),
            ('ldt_id', self.gf('django.db.models.fields.CharField')(unique=True, max_length=255)), #this does not match modeldefinition because of mysql limitations
            ('ldt', self.gf('django.db.models.fields.TextField')(null=True)),
            ('title', self.gf('django.db.models.fields.CharField')(max_length=1024)),
            ('creation_date', self.gf('django.db.models.fields.DateTimeField')(auto_now_add=True, blank=True)),
            ('modification_date', self.gf('django.db.models.fields.DateTimeField')(auto_now=True, blank=True)),
            ('created_by', self.gf('django.db.models.fields.CharField')(max_length=70)),
            ('changed_by', self.gf('django.db.models.fields.CharField')(max_length=70)),
            ('state', self.gf('django.db.models.fields.IntegerField')(default=1)),
        ))
        db.send_create_signal('ldt_utils', ['Project'])

        # Adding M2M table for field contents on 'Project'
        db.create_table('ldt_utils_project_contents', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('project', models.ForeignKey(orm['ldt_utils.project'], null=False)),
            ('content', models.ForeignKey(orm['ldt_utils.content'], null=False))
        ))
        db.create_unique('ldt_utils_project_contents', ['project_id', 'content_id'])

        # Adding model 'Segment'
        db.create_table('ldt_utils_segment', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('project_obj', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['ldt_utils.Project'], null=True)),
            ('content', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['ldt_utils.Content'])),
            ('project_id', self.gf('django.db.models.fields.CharField')(max_length=1024, null=True, blank=True)),
            ('iri_id', self.gf('django.db.models.fields.CharField')(max_length=1024)),
            ('ensemble_id', self.gf('django.db.models.fields.CharField')(max_length=1024)),
            ('cutting_id', self.gf('django.db.models.fields.CharField')(max_length=1024)),
            ('element_id', self.gf('django.db.models.fields.CharField')(max_length=1024)),
            ('tags', self.gf('tagging.fields.TagField')(max_length=2048, null=True)),
            ('title', self.gf('django.db.models.fields.CharField')(max_length=2048, null=True, blank=True)),
            ('duration', self.gf('django.db.models.fields.IntegerField')(null=True)),
            ('start_ts', self.gf('django.db.models.fields.IntegerField')(null=True)),
            ('author', self.gf('django.db.models.fields.CharField')(max_length=1024, null=True, blank=True)),
            ('date', self.gf('django.db.models.fields.CharField')(max_length=128, null=True, blank=True)),
            ('abstract', self.gf('django.db.models.fields.TextField')(null=True, blank=True)),
        ))
        db.send_create_signal('ldt_utils', ['Segment'])

        # Adding unique constraint on 'Segment', fields ['project_id', 'iri_id', 'ensemble_id', 'cutting_id', 'element_id']
        #db.create_unique('ldt_utils_segment', ['project_id', 'iri_id', 'ensemble_id', 'cutting_id', 'element_id'])


    def backwards(self, orm):
        
        # Removing unique constraint on 'Segment', fields ['project_id', 'iri_id', 'ensemble_id', 'cutting_id', 'element_id']
        #db.delete_unique('ldt_utils_segment', ['project_id', 'iri_id', 'ensemble_id', 'cutting_id', 'element_id'])

        # Deleting model 'Author'
        db.delete_table('ldt_utils_author')

        # Deleting model 'Media'
        db.delete_table('ldt_utils_media')

        # Deleting model 'Content'
        db.delete_table('ldt_utils_content')

        # Removing M2M table for field authors on 'Content'
        db.delete_table('ldt_utils_content_authors')

        # Deleting model 'Project'
        db.delete_table('ldt_utils_project')

        # Removing M2M table for field contents on 'Project'
        db.delete_table('ldt_utils_project_contents')

        # Deleting model 'Segment'
        db.delete_table('ldt_utils_segment')


    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'core.owner': {
            'Meta': {'object_name': 'Owner'},
            'group': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['auth.Group']", 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['auth.User']", 'null': 'True', 'blank': 'True'})
        },
        'ldt_utils.author': {
            'Meta': {'object_name': 'Author'},
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'null': 'True', 'blank': 'True'}),
            'firstname': ('django.db.models.fields.CharField', [], {'max_length': '512', 'null': 'True', 'blank': 'True'}),
            'handle': ('django.db.models.fields.CharField', [], {'max_length': '512', 'unique': 'True', 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'lastname': ('django.db.models.fields.CharField', [], {'max_length': '512', 'null': 'True', 'blank': 'True'})
        },
        'ldt_utils.content': {
            'Meta': {'ordering': "['title']", 'object_name': 'Content'},
            'authors': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['ldt_utils.Author']", 'symmetrical': 'False', 'blank': 'True'}),
            'content_creation_date': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'creation_date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'description': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'duration': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'iri_id': ('django.db.models.fields.CharField', [], {'default': "u'54150594-c974-11e0-a397-58b035f6b93d'", 'unique': 'True', 'max_length': '1024'}),
            'iriurl': ('django.db.models.fields.CharField', [], {'max_length': '1024'}),
            'media_obj': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['ldt_utils.Media']", 'null': 'True', 'blank': 'True'}),
            'tags': ('tagging.fields.TagField', [], {'max_length': '2048', 'null': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'null': 'True', 'blank': 'True'}),
            'update_date': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'})
        },
        'ldt_utils.media': {
            'Meta': {'object_name': 'Media'},
            'creation_date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'creator': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['auth.User']", 'null': 'True', 'blank': 'True'}),
            'description': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'duration': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'external_id': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'null': 'True', 'blank': 'True'}),
            'external_permalink': ('django.db.models.fields.URLField', [], {'max_length': '1024', 'null': 'True', 'blank': 'True'}),
            'external_publication_url': ('django.db.models.fields.URLField', [], {'max_length': '1024', 'null': 'True', 'blank': 'True'}),
            'external_src_url': ('django.db.models.fields.URLField', [], {'max_length': '1024', 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'media_creation_date': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'src': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '1024'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'null': 'True', 'blank': 'True'}),
            'update_date': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'videopath': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'null': 'True', 'blank': 'True'})
        },
        'ldt_utils.project': {
            'Meta': {'ordering': "['title']", 'object_name': 'Project'},
            'changed_by': ('django.db.models.fields.CharField', [], {'max_length': '70'}),
            'contents': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['ldt_utils.Content']", 'symmetrical': 'False'}),
            'created_by': ('django.db.models.fields.CharField', [], {'max_length': '70'}),
            'creation_date': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'ldt': ('django.db.models.fields.TextField', [], {'null': 'True'}),
            'ldt_id': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '1024'}),
            'modification_date': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'owner': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['core.Owner']", 'null': 'True', 'blank': 'True'}),
            'state': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '1024'})
        },
        'ldt_utils.segment': {
            'Meta': {'unique_together': "(('project_id', 'iri_id', 'ensemble_id', 'cutting_id', 'element_id'),)", 'object_name': 'Segment'},
            'abstract': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'author': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'null': 'True', 'blank': 'True'}),
            'content': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['ldt_utils.Content']"}),
            'cutting_id': ('django.db.models.fields.CharField', [], {'max_length': '1024'}),
            'date': ('django.db.models.fields.CharField', [], {'max_length': '128', 'null': 'True', 'blank': 'True'}),
            'duration': ('django.db.models.fields.IntegerField', [], {'null': 'True'}),
            'element_id': ('django.db.models.fields.CharField', [], {'max_length': '1024'}),
            'ensemble_id': ('django.db.models.fields.CharField', [], {'max_length': '1024'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'iri_id': ('django.db.models.fields.CharField', [], {'max_length': '1024'}),
            'project_id': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'null': 'True', 'blank': 'True'}),
            'project_obj': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['ldt_utils.Project']", 'null': 'True'}),
            'start_ts': ('django.db.models.fields.IntegerField', [], {'null': 'True'}),
            'tags': ('tagging.fields.TagField', [], {'max_length': '2048', 'null': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '2048', 'null': 'True', 'blank': 'True'})
        }
    }

    complete_apps = ['ldt_utils']
