from django.conf import settings
from social_auth.backends import get_backends


def check_access(user, obj):
    check_meth = getattr(obj, 'check_access', False)
    if check_meth:
        return check_meth(user)
    else:
        return user.is_staff

def social_list():
    """Start list process"""
    l = []
    # We list all wanted backends among all availables 
    for backend in get_backends():
        for backend_str in settings.AUTHENTICATION_BACKENDS:
            if backend in backend_str:
                l.append(backend)
    return l