import os
import re
import ast
from distutils.core import setup

here = os.path.dirname(os.path.abspath(__file__))

def get_version():
    f = open(os.path.join(here, 'fablib','__init__.py'))
    version_file = f.read()
    f.close()
    version_match = re.search(r"^VERSION\s*=\s*(\([^\)]*\))",
                              version_file, re.M)
    if version_match:
            VERSION = ast.literal_eval(version_match.group(1))
             
            version = '%s.%s' % (VERSION[0], VERSION[1])
            if VERSION[2]:
                version = '%s.%s' % (version, VERSION[2])
            if VERSION[3:] == ('alpha', 0):
                version = '%s.pre-alpha' % version
            elif VERSION[3] != 'final':
                version = '%s.%s.%s' % (version, VERSION[3], VERSION[4])
            return version

        
    raise RuntimeError("Unable to find version string.")

setup(
    name='fablib',
    version=get_version(),
    description='IRI fablib',
    author='IRI',
    author_email='dev@iri.centrepompidou.fr',
    url='http://www.iri.centrepompidou.fr',
    packages=['fablib'],
    data_files=[('','README.rst')],
    requires=["fabric(>1.5)", "mercurial(>=2.5)"]
)