from django import forms
from models import Project, Content
import uuid

class LdtImportForm(forms.Form):
    importFile = forms.FileField()
    videoPath = forms.CharField(required=False)
    flatten = forms.BooleanField(required=False, initial=True)   
    
class LdtAddForm(forms.ModelForm):
    title = forms.CharField()
    # contents = forms.ModelMultipleChoiceField(Content.objects.all())
    # owner = forms.ModelChoiceField(Author.objects.all())
    class Meta:
        model = Project
        exclude = ("ldt_id", "ldt", "created_by", "changed_by", "creation_date", "modification_date", "state", "owner")   

class ReindexForm(forms.Form):
    contents = forms.ModelMultipleChoiceField(Content.objects.all())

class SearchForm(forms.Form):
    search = forms.CharField()
    field = forms.ChoiceField([(u"all", u"all"), (u"title", u"title"), (u"abstract", u"resume"), (u"tags", u"tags")])

class AddProjectForm (forms.Form):
    title = forms.CharField()

class CopyProjectForm (forms.Form):
    title = forms.CharField()
