from django.conf import settings
from django.http import HttpResponse, HttpResponseRedirect
from django.shortcuts import render_to_response
from django.contrib.auth import authenticate, login, logout
from django.contrib.auth.decorators import login_required
# from django.contrib.sites.models import Site, RequestSite
from django.template import RequestContext, Context, loader
from django.utils.translation import ugettext as _
from django.core.urlresolvers import reverse
from forms import EmailChangeForm
from django.utils import simplejson
from ldt.management import test_cms, test_ldt


def home(request):
    return render_to_response('ldt/user/home.html',context_instance=RequestContext(request))
    
@login_required   
def profile(request):
    return render_to_response('ldt/user/profile.html', context_instance=RequestContext(request))

@login_required     
def space(request, page_id=None, slug=None):
    cms = test_cms()
    ldt = test_ldt()
    context={
        'cms': cms,
        'ldt': ldt
    }
    return render_to_response('ldt/user/space.html', context, context_instance=RequestContext(request))
    

    
def logout_view(request):
    logout(request)
    # return HttpResponseRedirect(request.META.get('HTTP_REFERER', '/'))
    return HttpResponseRedirect(settings.LOGOUT_URL)

    
def loginAjax(request, loginstate_template_name='ldt/user/login_form.html'):
    if request.method == "POST":
        username=request.POST["username"]
        password=request.POST["password"]
        user = authenticate(username=username, password=password)
        error_message = _(u"Sorry, that's not a valid username or password.")
        if user is not None:
            if user.is_active:
                login(request, user)
                context = RequestContext(request, { 'username': user.username,})
                template = loader.get_template(loginstate_template_name)
                html = template.render(context)
                return HttpResponse(simplejson.dumps({'message': u'successful', 'username': user.username, 'html': html, 'reload': request.POST["reload"],}))               
            else:
                return HttpResponse(simplejson.dumps({'message': error_message,}))
        else:
            return HttpResponse(simplejson.dumps({'message': error_message,}))
    return render_to_response('ldt/user/login_ajax.html', context_instance=RequestContext(request))
            
@login_required              
def change_email(request, post_change_redirect=None):
    if post_change_redirect is None:
        post_change_redirect = reverse('ldt.user.views.change_email_done')
    if request.method == "POST":
        form = EmailChangeForm(request.user, request.POST)
        if form.is_valid():
            form.save()
            return HttpResponseRedirect(post_change_redirect)
    else:
        form = EmailChangeForm(request.user)
    return render_to_response('ldt/user/change_email.html', {'form': form,}, context_instance=RequestContext(request))
    
@login_required    
def change_email_done(request, template_name='ldt/user/change_email_done.html'):
    return render_to_response(template_name, context_instance=RequestContext(request))

